/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.smtp;

import com.sun.mail.smtp.SMTPMessage;
import com.sun.mail.smtp.SMTPOutputStream;
import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64EncoderStream;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.SocketFetcher;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.ParseException;

public class SMTPTransport
extends Transport {
    private MimeMessage message;
    private Address[] addresses;
    private Address[] validSentAddr;
    private Address[] validUnsentAddr;
    private Address[] invalidAddr;
    boolean sendPartiallyFailed = false;
    MessagingException exception;
    private Hashtable extMap;
    private boolean noAuth = false;
    private String name = "smtp";
    private PrintStream out;
    private static String localHostName;
    private static final String[] ignoreList;
    private static final byte[] CRLF;
    private BufferedInputStream serverInput;
    private LineInputStream lineInputStream;
    private OutputStream serverOutput;
    private String lastServerResponse;
    private Socket serverSocket;

    public SMTPTransport(Session session, URLName uRLName) {
        super(session, uRLName);
        this.out = session.getDebugOut();
        if (uRLName != null) {
            this.name = uRLName.getProtocol();
        }
    }

    private String getLocalHost() {
        try {
            if (localHostName == null || localHostName.length() <= 0) {
                localHostName = ((Service)this).session.getProperty("mail." + this.name + ".localhost");
            }
            if (localHostName == null || localHostName.length() <= 0) {
                localHostName = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {}
        return localHostName;
    }

    public synchronized void connect() throws MessagingException {
        try {
            this.noAuth = true;
            super.connect();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.noAuth = false;
            throw throwable;
        }
        Object var2_1 = null;
        this.noAuth = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean protocolConnect(String string, int n, String string2, String string3) throws MessagingException {
        boolean bl;
        block24: {
            boolean bl2;
            String string4 = ((Service)this).session.getProperty("mail." + this.name + ".ehlo");
            boolean bl3 = string4 == null || !string4.equalsIgnoreCase("false");
            String string5 = ((Service)this).session.getProperty("mail." + this.name + ".auth");
            boolean bl4 = bl2 = string5 != null && string5.equalsIgnoreCase("true");
            if (((Service)this).debug) {
                this.out.println("DEBUG SMTP: useEhlo " + bl3 + ", useAuth " + bl2);
            }
            if (bl2 && (string2 == null || string3 == null)) {
                return false;
            }
            if (n == -1) {
                String string6 = ((Service)this).session.getProperty("mail." + this.name + ".port");
                n = string6 != null ? Integer.parseInt(string6) : 25;
            }
            if (string == null || string.length() == 0) {
                string = "localhost";
            }
            bl = false;
            this.openServer(string, n);
            if (bl3) {
                bl = this.ehlo(this.getLocalHost());
            }
            if (bl && bl2 && (this.supportsExtension("AUTH") || this.supportsExtension("AUTH=LOGIN"))) {
                if (((Service)this).debug) {
                    this.out.println("DEBUG SMTP: Attempt to authenticate");
                    if (!this.supportsAuthentication("LOGIN") && this.supportsExtension("AUTH=LOGIN")) {
                        this.out.println("DEBUG SMTP use AUTH=LOGIN hack");
                    }
                }
                if (this.supportsAuthentication("LOGIN") || this.supportsExtension("AUTH=LOGIN")) {
                    int n2 = this.simpleCommand("AUTH LOGIN");
                    try {
                        try {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            BASE64EncoderStream bASE64EncoderStream = new BASE64EncoderStream((OutputStream)byteArrayOutputStream, Integer.MAX_VALUE);
                            if (n2 == 334) {
                                bASE64EncoderStream.write(ASCIIUtility.getBytes((String)string2));
                                bASE64EncoderStream.flush();
                                n2 = this.simpleCommand(byteArrayOutputStream.toByteArray());
                                byteArrayOutputStream.reset();
                            }
                            if (n2 == 334) {
                                bASE64EncoderStream.write(ASCIIUtility.getBytes((String)string3));
                                bASE64EncoderStream.flush();
                                n2 = this.simpleCommand(byteArrayOutputStream.toByteArray());
                                byteArrayOutputStream.reset();
                            }
                        }
                        catch (IOException iOException) {
                        }
                        Object var12_17 = null;
                        if (n2 == 235) break block24;
                    }
                    catch (Throwable throwable) {
                        Object var12_18 = null;
                        if (n2 != 235) {
                            this.closeConnection();
                            return false;
                        }
                        throw throwable;
                    }
                    this.closeConnection();
                    return false;
                }
                if (this.supportsAuthentication("PLAIN")) {
                    int n3 = this.simpleCommand("AUTH PLAIN");
                    try {
                        try {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            BASE64EncoderStream bASE64EncoderStream = new BASE64EncoderStream((OutputStream)byteArrayOutputStream, Integer.MAX_VALUE);
                            if (n3 == 334) {
                                bASE64EncoderStream.write(0);
                                bASE64EncoderStream.write(ASCIIUtility.getBytes((String)string2));
                                bASE64EncoderStream.write(0);
                                bASE64EncoderStream.write(ASCIIUtility.getBytes((String)string3));
                                bASE64EncoderStream.flush();
                                n3 = this.simpleCommand(byteArrayOutputStream.toByteArray());
                            }
                        }
                        catch (IOException iOException) {
                        }
                        Object var12_19 = null;
                        if (n3 == 235) break block24;
                    }
                    catch (Throwable throwable) {
                        Object var12_20 = null;
                        if (n3 != 235) {
                            this.closeConnection();
                            return false;
                        }
                        throw throwable;
                    }
                    this.closeConnection();
                    return false;
                }
            }
        }
        if (!bl) {
            this.helo(this.getLocalHost());
        }
        return true;
    }

    public synchronized void sendMessage(Message message, Address[] addressArray) throws MessagingException, SendFailedException {
        this.checkConnected();
        if (!(message instanceof MimeMessage)) {
            if (((Service)this).debug) {
                this.out.println("DEBUG SMTP: Can only send RFC822 msgs");
            }
            throw new MessagingException("SMTP can only send RFC822 messages");
        }
        int n = 0;
        while (n < addressArray.length) {
            if (!(addressArray[n] instanceof InternetAddress)) {
                throw new MessagingException(String.valueOf(addressArray[n]) + " is not an InternetAddress");
            }
            ++n;
        }
        this.message = (MimeMessage)message;
        this.addresses = addressArray;
        this.expandGroups();
        boolean bl = false;
        if (message instanceof SMTPMessage) {
            bl = ((SMTPMessage)message).getAllow8bitMIME();
        }
        if (!bl) {
            String string = ((Service)this).session.getProperty("mail." + this.name + ".allow8bitmime");
            boolean bl2 = bl = string != null && string.equalsIgnoreCase("true");
        }
        if (((Service)this).debug) {
            this.out.println("DEBUG SMTP: use8bit " + bl);
        }
        if (bl && this.supportsExtension("8BITMIME")) {
            this.convertTo8Bit((MimePart)this.message);
        }
        try {
            try {
                this.mailFrom();
                this.rcptTo();
                this.message.writeTo(this.data(), ignoreList);
                this.finishData();
                if (this.sendPartiallyFailed) {
                    if (((Service)this).debug) {
                        this.out.println("DEBUG SMTPTransport: Sending partially failed because of invalid destination addresses");
                    }
                    this.notifyTransportListeners(3, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, (Message)this.message);
                    throw new SendFailedException("Message partially delivered", (Exception)((Object)this.exception), this.validSentAddr, this.validUnsentAddr, this.invalidAddr);
                }
                this.notifyTransportListeners(1, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, (Message)this.message);
            }
            catch (IOException iOException) {
                if (((Service)this).debug) {
                    iOException.printStackTrace(this.out);
                }
                try {
                    this.closeConnection();
                }
                catch (MessagingException messagingException) {}
                this.notifyTransportListeners(2, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, (Message)this.message);
                throw new MessagingException("IOException while sending message", (Exception)iOException);
            }
            Object var6_8 = null;
            this.invalidAddr = null;
            this.validUnsentAddr = null;
            this.validSentAddr = null;
            this.addresses = null;
            this.message = null;
            this.exception = null;
            this.sendPartiallyFailed = false;
            return;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.invalidAddr = null;
            this.validUnsentAddr = null;
            this.validSentAddr = null;
            this.addresses = null;
            this.message = null;
            this.exception = null;
            this.sendPartiallyFailed = false;
            throw throwable;
        }
    }

    public synchronized void close() throws MessagingException {
        block3: {
            if (!super.isConnected()) {
                return;
            }
            try {
                if (this.serverSocket == null) break block3;
                this.sendCommand("QUIT");
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.closeConnection();
                throw throwable;
            }
        }
        Object var2_1 = null;
        this.closeConnection();
    }

    private void closeConnection() throws MessagingException {
        try {
            try {
                if (this.serverSocket != null) {
                    this.serverSocket.close();
                }
            }
            catch (IOException iOException) {
                throw new MessagingException("Server Close Failed", (Exception)iOException);
            }
            Object var2_2 = null;
            this.serverSocket = null;
            this.serverOutput = null;
            this.serverInput = null;
            this.lineInputStream = null;
        }
        catch (Throwable throwable) {
            block6: {
                Object var2_3 = null;
                this.serverSocket = null;
                this.serverOutput = null;
                this.serverInput = null;
                this.lineInputStream = null;
                if (!super.isConnected()) break block6;
                super.close();
            }
            throw throwable;
        }
        if (super.isConnected()) {
            super.close();
        }
    }

    public synchronized boolean isConnected() {
        if (!super.isConnected()) {
            return false;
        }
        try {
            this.sendCommand("NOOP");
            int n = this.readServerResponse();
            if (n >= 0) {
                return true;
            }
            try {
                this.closeConnection();
            }
            catch (MessagingException messagingException) {}
            return false;
        }
        catch (Exception exception) {
            try {
                this.closeConnection();
            }
            catch (MessagingException messagingException) {}
            return false;
        }
    }

    private void expandGroups() {
        InternetAddress internetAddress;
        Vector<InternetAddress> vector = null;
        int n = 0;
        while (n < this.addresses.length) {
            internetAddress = (InternetAddress)this.addresses[n];
            if (internetAddress.isGroup()) {
                if (vector == null) {
                    vector = new Vector<InternetAddress>();
                    int n2 = 0;
                    while (n2 < n) {
                        vector.addElement((InternetAddress)this.addresses[n2]);
                        ++n2;
                    }
                }
                try {
                    InternetAddress[] internetAddressArray = internetAddress.getGroup(true);
                    if (internetAddressArray != null) {
                        int n3 = 0;
                        while (n3 < internetAddressArray.length) {
                            vector.addElement(internetAddressArray[n3]);
                            ++n3;
                        }
                    } else {
                        vector.addElement(internetAddress);
                    }
                }
                catch (ParseException parseException) {
                    vector.addElement(internetAddress);
                }
            } else if (vector != null) {
                vector.addElement(internetAddress);
            }
            ++n;
        }
        if (vector != null) {
            internetAddress = new InternetAddress[vector.size()];
            vector.copyInto((Object[])internetAddress);
            this.addresses = internetAddress;
        }
    }

    private void convertTo8Bit(MimePart mimePart) {
        block8: {
            try {
                block11: {
                    block9: {
                        block10: {
                            if (!mimePart.isMimeType("text/*")) break block9;
                            String string = mimePart.getEncoding();
                            if (!string.equalsIgnoreCase("quoted-printable") && !string.equalsIgnoreCase("base64")) break block10;
                            InputStream inputStream = mimePart.getInputStream();
                            if (!this.is8Bit(inputStream)) break block11;
                            mimePart.setHeader("Content-Transfer-Encoding", "8bit");
                        }
                        return;
                    }
                    if (mimePart.isMimeType("multipart/*")) {
                        MimeMultipart mimeMultipart = (MimeMultipart)mimePart.getContent();
                        int n = mimeMultipart.getCount();
                        int n2 = 0;
                        while (n2 < n) {
                            this.convertTo8Bit((MimePart)mimeMultipart.getBodyPart(n2));
                            ++n2;
                        }
                    }
                    break block8;
                }
                return;
            }
            catch (IOException iOException) {
                return;
            }
            catch (MessagingException messagingException) {}
        }
    }

    private boolean is8Bit(InputStream inputStream) {
        int n = 0;
        boolean bl = false;
        try {
            int n2;
            while ((n2 = inputStream.read()) >= 0) {
                if ((n2 &= 0xFF) == 13 || n2 == 10) {
                    n = 0;
                } else {
                    if (n2 == 0) {
                        return false;
                    }
                    if (++n > 998) {
                        return false;
                    }
                }
                if (n2 <= 127) continue;
                bl = true;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        if (((Service)this).debug && bl) {
            this.out.println("DEBUG SMTP: found an 8bit part");
        }
        return bl;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        try {
            this.closeConnection();
            return;
        }
        catch (MessagingException messagingException) {
            return;
        }
    }

    private void helo(String string) throws MessagingException {
        if (string != null) {
            this.issueCommand("HELO " + string, 250);
            return;
        }
        this.issueCommand("HELO", 250);
    }

    private boolean ehlo(String string) throws MessagingException {
        String string2 = string != null ? "EHLO " + string : "EHLO";
        this.sendCommand(string2);
        int n = this.readServerResponse();
        if (n == 250) {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(this.lastServerResponse));
            this.extMap = new Hashtable();
            try {
                String string3;
                boolean bl = true;
                while ((string3 = bufferedReader.readLine()) != null) {
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    if (string3.length() < 5) continue;
                    string3 = string3.substring(4);
                    int n2 = string3.indexOf(32);
                    String string4 = "";
                    if (n2 > 0) {
                        string4 = string3.substring(n2 + 1);
                        string3 = string3.substring(0, n2);
                    }
                    if (((Service)this).debug) {
                        this.out.println("DEBUG SMTP Found extension \"" + string3 + "\", arg \"" + string4 + "\"");
                    }
                    this.extMap.put(string3.toUpperCase(), string4);
                }
            }
            catch (IOException iOException) {}
        }
        return n == 250;
    }

    private void mailFrom() throws MessagingException {
        Object object;
        Object object2;
        String string = null;
        if (this.message instanceof SMTPMessage) {
            string = ((SMTPMessage)this.message).getEnvelopeFrom();
        }
        if (string == null || string.length() <= 0) {
            string = ((Service)this).session.getProperty("mail." + this.name + ".from");
        }
        if (string == null || string.length() <= 0) {
            object = this.message != null && (object2 = this.message.getFrom()) != null && ((Address[])object2).length > 0 ? object2[0] : InternetAddress.getLocalAddress((Session)((Service)this).session);
            if (object != null) {
                string = object.getAddress();
            } else {
                throw new MessagingException("can't determine local email address");
            }
        }
        object2 = "MAIL FROM:" + this.normalizeAddress(string);
        if (this.supportsExtension("DSN")) {
            object = null;
            if (this.message instanceof SMTPMessage) {
                object = ((SMTPMessage)this.message).getDSNRet();
            }
            if (object == null) {
                object = ((Service)this).session.getProperty("mail." + this.name + ".dsn.ret");
            }
            if (object != null) {
                object2 = String.valueOf(object2) + " RET=" + (String)object;
            }
        }
        this.issueCommand((String)object2, 250);
    }

    private void rcptTo() throws MessagingException {
        Vector<Address> vector = new Vector<Address>();
        Vector<Address> vector2 = new Vector<Address>();
        Vector<Address> vector3 = new Vector<Address>();
        int n = -1;
        SendFailedException sendFailedException = null;
        boolean bl = false;
        SendFailedException sendFailedException2 = null;
        this.invalidAddr = null;
        this.validUnsentAddr = null;
        this.validSentAddr = null;
        boolean bl2 = false;
        if (this.message instanceof SMTPMessage) {
            bl2 = ((SMTPMessage)this.message).getSendPartial();
        }
        if (!bl2) {
            String string = ((Service)this).session.getProperty("mail." + this.name + ".sendpartial");
            bl2 = string != null && string.equalsIgnoreCase("true");
        }
        boolean bl3 = false;
        String string = null;
        if (this.supportsExtension("DSN")) {
            if (this.message instanceof SMTPMessage) {
                string = ((SMTPMessage)this.message).getDSNNotify();
            }
            if (string == null) {
                string = ((Service)this).session.getProperty("mail." + this.name + ".dsn.notify");
            }
            if (string != null) {
                bl3 = true;
            }
        }
        int n2 = 0;
        while (n2 < this.addresses.length) {
            sendFailedException2 = null;
            String string2 = "RCPT TO:" + this.normalizeAddress(((InternetAddress)this.addresses[n2]).getAddress());
            if (bl3) {
                string2 = String.valueOf(string2) + " NOTIFY=" + string;
            }
            this.sendCommand(string2);
            n = this.readServerResponse();
            switch (n) {
                case 250: 
                case 251: {
                    vector.addElement(this.addresses[n2]);
                    break;
                }
                case 501: 
                case 503: 
                case 550: 
                case 551: 
                case 553: {
                    if (!bl2) {
                        bl = true;
                    }
                    vector3.addElement(this.addresses[n2]);
                    sendFailedException2 = new SendFailedException(this.lastServerResponse);
                    if (sendFailedException == null) {
                        sendFailedException = sendFailedException2;
                        break;
                    }
                    sendFailedException.setNextException((Exception)sendFailedException2);
                    break;
                }
                case 450: 
                case 451: 
                case 452: 
                case 552: {
                    if (!bl2) {
                        bl = true;
                    }
                    vector2.addElement(this.addresses[n2]);
                    sendFailedException2 = new SendFailedException(this.lastServerResponse);
                    if (sendFailedException == null) {
                        sendFailedException = sendFailedException2;
                        break;
                    }
                    sendFailedException.setNextException((Exception)sendFailedException2);
                    break;
                }
                default: {
                    if (n >= 400 && n <= 499) {
                        vector2.addElement(this.addresses[n2]);
                    } else if (n >= 500 && n <= 599) {
                        vector3.addElement(this.addresses[n2]);
                    } else {
                        String string3 = this.lastServerResponse;
                        this.issueCommand("RSET", 250);
                        throw new SendFailedException(string3);
                    }
                    if (!bl2) {
                        bl = true;
                    }
                    sendFailedException2 = new SendFailedException(this.lastServerResponse);
                    if (sendFailedException == null) {
                        sendFailedException = sendFailedException2;
                        break;
                    }
                    sendFailedException.setNextException((Exception)sendFailedException2);
                    break;
                }
            }
            ++n2;
        }
        if (bl2 && vector.size() == 0) {
            bl = true;
        }
        if (bl) {
            this.invalidAddr = new Address[vector3.size()];
            vector3.copyInto(this.invalidAddr);
            this.validUnsentAddr = new Address[vector.size() + vector2.size()];
            int n3 = 0;
            int n4 = 0;
            while (n4 < vector.size()) {
                this.validUnsentAddr[n3++] = (Address)vector.elementAt(n4);
                ++n4;
            }
            int n5 = 0;
            while (n5 < vector2.size()) {
                this.validUnsentAddr[n3++] = (Address)vector2.elementAt(n5);
                ++n5;
            }
        } else if (bl2 && (vector3.size() > 0 || vector2.size() > 0)) {
            this.sendPartiallyFailed = true;
            this.exception = sendFailedException;
            this.invalidAddr = new Address[vector3.size()];
            vector3.copyInto(this.invalidAddr);
            this.validUnsentAddr = new Address[vector2.size()];
            vector2.copyInto(this.validUnsentAddr);
            this.validSentAddr = new Address[vector.size()];
            vector.copyInto(this.validSentAddr);
        } else {
            this.validSentAddr = this.addresses;
        }
        if (((Service)this).debug) {
            if (this.validSentAddr != null && this.validSentAddr.length > 0) {
                this.out.println("Verified Addresses");
                int n6 = 0;
                while (n6 < this.validSentAddr.length) {
                    this.out.println("  " + this.validSentAddr[n6]);
                    ++n6;
                }
            }
            if (this.validUnsentAddr != null && this.validUnsentAddr.length > 0) {
                this.out.println("Valid Unsent Addresses");
                int n7 = 0;
                while (n7 < this.validUnsentAddr.length) {
                    this.out.println("  " + this.validUnsentAddr[n7]);
                    ++n7;
                }
            }
            if (this.invalidAddr != null && this.invalidAddr.length > 0) {
                this.out.println("Invalid Addresses");
                int n8 = 0;
                while (n8 < this.invalidAddr.length) {
                    this.out.println("  " + this.invalidAddr[n8]);
                    ++n8;
                }
            }
        }
        if (bl) {
            block43: {
                if (((Service)this).debug) {
                    this.out.println("DEBUG SMTPTransport: Sending failed because of invalid destination addresses");
                }
                this.notifyTransportListeners(2, this.validSentAddr, this.validUnsentAddr, this.invalidAddr, (Message)this.message);
                try {
                    this.issueCommand("RSET", 250);
                }
                catch (MessagingException messagingException) {
                    try {
                        this.close();
                    }
                    catch (MessagingException messagingException2) {
                        if (!((Service)this).debug) break block43;
                        messagingException2.printStackTrace(this.out);
                    }
                }
            }
            throw new SendFailedException("Invalid Addresses", (Exception)sendFailedException, this.validSentAddr, this.validUnsentAddr, this.invalidAddr);
        }
    }

    private OutputStream data() throws MessagingException {
        this.issueCommand("DATA", 354);
        return new SMTPOutputStream(this.serverOutput);
    }

    private void finishData() throws MessagingException {
        this.issueCommand("\r\n.", 250);
    }

    private void openServer(String string, int n) throws MessagingException {
        if (((Service)this).debug) {
            this.out.println("\nDEBUG: SMTPTransport trying to connect to host \"" + string + "\", port " + n + "\n");
        }
        ((Service)this).session.getProperties();
        try {
            this.serverSocket = SocketFetcher.getSocket((String)string, (int)n, (Properties)((Service)this).session.getProperties(), (String)("mail." + this.name));
            this.serverOutput = new BufferedOutputStream(this.serverSocket.getOutputStream());
            this.serverInput = new BufferedInputStream(this.serverSocket.getInputStream());
            this.lineInputStream = new LineInputStream((InputStream)this.serverInput);
            if (this.readServerResponse() != 220) {
                this.serverSocket.close();
                this.serverSocket = null;
                this.serverOutput = null;
                this.serverInput = null;
                this.lineInputStream = null;
                if (((Service)this).debug) {
                    this.out.println("DEBUG: SMTPTransport could not connect to host \"" + string + "\", port: " + n + "\n");
                }
                throw new MessagingException("Could not connect to SMTP host: " + string + ", port: " + n);
            }
            if (((Service)this).debug) {
                this.out.println("DEBUG: SMTPTransport connected to host \"" + string + "\", port: " + n + "\n");
                return;
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new MessagingException("Unknown SMTP host: " + string, (Exception)unknownHostException);
        }
        catch (IOException iOException) {
            throw new MessagingException("Could not connect to SMTP host: " + string + ", port: " + n, (Exception)iOException);
        }
    }

    private void issueCommand(String string, int n) throws MessagingException {
        this.sendCommand(string);
        if (this.readServerResponse() != n) {
            throw new MessagingException(this.lastServerResponse);
        }
    }

    private int simpleCommand(String string) throws MessagingException {
        this.sendCommand(string);
        return this.readServerResponse();
    }

    private int simpleCommand(byte[] byArray) throws MessagingException {
        this.sendCommand(byArray);
        return this.readServerResponse();
    }

    private void sendCommand(String string) throws MessagingException {
        this.sendCommand(ASCIIUtility.getBytes((String)string));
    }

    private void sendCommand(byte[] byArray) throws MessagingException {
        if (((Service)this).debug) {
            this.out.println("DEBUG SMTP SENT: " + new String(byArray, 0));
        }
        try {
            this.serverOutput.write(byArray);
            this.serverOutput.write(CRLF);
            this.serverOutput.flush();
            return;
        }
        catch (IOException iOException) {
            throw new MessagingException("Can't send command to SMTP host", (Exception)iOException);
        }
    }

    private int readServerResponse() {
        String string = "";
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(100);
        try {
            String string2 = null;
            do {
                if ((string2 = this.lineInputStream.readLine()) == null) {
                    return -1;
                }
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            } while (this.isNotLastLine(string2));
            string = stringBuffer.toString();
        }
        catch (IOException iOException) {
            n = -1;
        }
        if (((Service)this).debug) {
            this.out.println("DEBUG SMTP RCVD: " + string);
        }
        if (n != -1 && string != null && string.length() >= 3) {
            try {
                n = Integer.parseInt(string.substring(0, 3));
            }
            catch (NumberFormatException numberFormatException) {
                block14: {
                    try {
                        this.close();
                    }
                    catch (MessagingException messagingException) {
                        if (!((Service)this).debug) break block14;
                        messagingException.printStackTrace(this.out);
                    }
                }
                n = -1;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                block15: {
                    try {
                        this.close();
                    }
                    catch (MessagingException messagingException) {
                        if (!((Service)this).debug) break block15;
                        messagingException.printStackTrace(this.out);
                    }
                }
                n = -1;
            }
        } else {
            n = -1;
        }
        this.lastServerResponse = string;
        return n;
    }

    private void checkConnected() {
        if (!super.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
    }

    private boolean isNotLastLine(String string) {
        return string != null && string.length() >= 4 && string.charAt(3) == '-';
    }

    private String normalizeAddress(String string) {
        if (!string.startsWith("<") && !string.endsWith(">")) {
            return "<" + string + ">";
        }
        return string;
    }

    private boolean supportsExtension(String string) {
        return this.extMap != null && this.extMap.get(string.toUpperCase()) != null;
    }

    private boolean supportsAuthentication(String string) {
        if (this.extMap == null) {
            return false;
        }
        String string2 = (String)this.extMap.get("AUTH");
        if (string2 == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!string3.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    static {
        ignoreList = new String[]{"Bcc", "Content-Length"};
        CRLF = new byte[]{13, 10};
    }
}

