/*
 * Decompiled with CFR 0.152.
 */
package org.intabulas.sandler.serialization;

import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import org.intabulas.sandler.elements.Content;
import org.intabulas.sandler.elements.Entry;
import org.intabulas.sandler.elements.Feed;
import org.intabulas.sandler.elements.Generator;
import org.intabulas.sandler.elements.Link;
import org.intabulas.sandler.elements.Person;
import org.intabulas.sandler.serialization.AbstractAtomSerializer;
import org.intabulas.sandler.serialization.SerializationException;
import org.intabulas.sandler.util.SandlerUtilities;

public class WriterSerializer
extends AbstractAtomSerializer {
    private Writer writer = null;

    public WriterSerializer() {
    }

    public WriterSerializer(Writer writer) {
        this.writer = writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void serializeContent(Content content, String elementName) throws IOException {
        this.writer.write("<");
        this.writer.write(elementName);
        if (content.getMimeType() != null) {
            this.writer.write(" ");
            this.writer.write("type");
            this.writer.write("=\"");
            this.writer.write(content.getMimeType());
            this.writer.write("\"");
        }
        if (content.getMode() != null) {
            this.writer.write(" ");
            this.writer.write("mode");
            this.writer.write("=\"");
            this.writer.write(content.getMode());
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writer.write(content.getBody());
        this.writer.write("</");
        this.writer.write(elementName);
        this.writer.write(">");
    }

    public void serializeLink(Link link) throws IOException {
        this.writer.write("<");
        this.writer.write("link");
        if (link.getRelationship() != null) {
            this.writer.write(" ");
            this.writer.write("rel");
            this.writer.write("=\"");
            this.writer.write(link.getRelationship());
            this.writer.write("\"");
        }
        if (link.getType() != null) {
            this.writer.write(" ");
            this.writer.write("type");
            this.writer.write("=\"");
            this.writer.write(link.getType());
            this.writer.write("\"");
        }
        if (link.getTitle() != null) {
            this.writer.write(" ");
            this.writer.write("title");
            this.writer.write("=\"");
            this.writer.write(link.getTitle());
            this.writer.write("\"");
        }
        if (link.getHref() != null) {
            this.writer.write(" ");
            this.writer.write("href");
            this.writer.write("=\"");
            this.writer.write(link.getHref());
            this.writer.write("\"");
        }
        this.writer.write("/>");
    }

    public void serializeGenerator(Generator generator) throws IOException {
        this.writer.write("<");
        this.writer.write("generator");
        if (generator.getVersion() != null) {
            this.writer.write(" ");
            this.writer.write("version");
            this.writer.write("=\"");
            this.writer.write(generator.getVersion());
            this.writer.write("\"");
        }
        if (generator.getUri() != null) {
            this.writer.write(" ");
            this.writer.write("url");
            this.writer.write("=\"");
            this.writer.write(generator.getUri());
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writer.write(generator.getName());
        this.writer.write("</");
        this.writer.write("generator");
        this.writer.write(">");
    }

    private void serializePerson(Person person) throws IOException {
        this.writer.write("<");
        this.writer.write("name");
        this.writer.write(">");
        this.writer.write(person.getName());
        this.writer.write("</");
        this.writer.write("name");
        this.writer.write(">");
        if (person.getEmail() != null) {
            this.writer.write("<");
            this.writer.write("email");
            this.writer.write(">");
            this.writer.write(person.getEmail());
            this.writer.write("</");
            this.writer.write("email");
            this.writer.write(">");
        }
        if (person.getUrl() != null) {
            this.writer.write("<");
            this.writer.write("url");
            this.writer.write(">");
            this.writer.write(person.getUrl());
            this.writer.write("</");
            this.writer.write("url");
            this.writer.write(">");
        }
    }

    public void serialize(Entry entry) throws SerializationException {
        this.serialize(entry, false);
    }

    public void serialize(Entry entry, boolean isDocument) throws SerializationException {
        try {
            int contentcnt;
            int contributorcnt;
            if (isDocument) {
                this.writer.write("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
                this.writer.write(MessageFormat.format("<{0}{1}>", "entry", " xmlns=\"http://purl.org/atom/ns#\""));
            } else {
                this.writer.write(MessageFormat.format("<{0}{1}>", "entry", "", ""));
            }
            this.serializeContent(entry.getTitle(), "title");
            this.writer.write(MessageFormat.format("<{0}>{1}{2}</{0}>", "id", "", entry.getId()));
            int linkcnt = entry.getLinkCount();
            if (linkcnt > 0) {
                for (int x = 0; x < linkcnt; ++x) {
                    this.serializeLink(entry.getLink(x));
                }
            }
            if (entry.getModified() != null) {
                this.writer.write(MessageFormat.format("<{0}>{1}{2}</{0}>", "modified", "", SandlerUtilities.getUTCDate(entry.getModified())));
            }
            if (entry.getIssued() != null) {
                this.writer.write(MessageFormat.format("<{0}>{1}{2}</{0}>", "issued", "", SandlerUtilities.getUTCDate(entry.getIssued())));
            }
            if (entry.getCreated() != null) {
                this.writer.write(MessageFormat.format("<{0}>{1}{2}</{0}>", "created", "", SandlerUtilities.getUTCDate(entry.getCreated())));
            }
            if (entry.getSummary() != null) {
                this.serializeContent(entry.getSummary(), "summary");
            }
            if (entry.getAuthor() != null) {
                this.writer.write("<");
                this.writer.write("author");
                this.writer.write(">");
                this.serializePerson(entry.getAuthor());
                this.writer.write("</");
                this.writer.write("author");
                this.writer.write(">");
            }
            if ((contributorcnt = entry.getContributorCount()) > 0) {
                for (int x = 0; x < contributorcnt; ++x) {
                    Person contributor = entry.getContributor(x);
                    this.writer.write("<");
                    this.writer.write("contributor");
                    this.writer.write(">");
                    this.serializePerson(contributor);
                    this.writer.write("</");
                    this.writer.write("contributor");
                    this.writer.write(">");
                }
            }
            if ((contentcnt = entry.getContentCount()) > 0) {
                for (int x = 0; x < contentcnt; ++x) {
                    Content content = entry.getContent(x);
                    if (content == null) continue;
                    this.serializeContent(content, "content");
                }
            }
            this.writer.write("</");
            this.writer.write("entry");
            this.writer.write(">");
            this.writer.flush();
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }

    public void serialize(Feed feed) throws SerializationException {
        try {
            int contributorcnt;
            int entrycnt;
            int linkcnt;
            this.writer.write("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
            String feedAttributes = MessageFormat.format(" version=\"{0}\" xml:lang=\"{1}\" xmlns=\"http://purl.org/atom/ns#\"", feed.getVersion(), feed.getLanguage());
            this.writer.write(MessageFormat.format("<{0}{1}>", "feed", feedAttributes));
            if (feed.getTitle() != null) {
                this.serializeContent(feed.getTitle(), "title");
            }
            if ((linkcnt = feed.getLinkCount()) > 0) {
                for (int x = 0; x < linkcnt; ++x) {
                    this.serializeLink(feed.getLink(x));
                }
            }
            if (feed.getModified() != null) {
                this.writer.write(MessageFormat.format("<{0}>{1}{2}</{0}>", "modified", SandlerUtilities.getUTCDate(feed.getModified())));
            }
            if (feed.getSummary() != null) {
                this.serializeContent(feed.getSummary(), "summary");
            }
            if (feed.getTagline() != null) {
                this.serializeContent(feed.getTagline(), "tagline");
            }
            if (feed.getInfo() != null) {
                this.serializeContent(feed.getInfo(), "info");
            }
            if (feed.getId() != null) {
                this.writer.write(MessageFormat.format("<{0}>{1}{2}</{0}>", "id", "", feed.getId()));
            }
            if (feed.getCopyright() != null) {
                this.serializeContent(feed.getCopyright(), "copyright");
            }
            if (feed.getGenerator() != null) {
                this.serializeGenerator(feed.getGenerator());
            }
            if (feed.getAuthor() != null) {
                this.writer.write("<");
                this.writer.write("author");
                this.writer.write(">");
                this.serializePerson(feed.getAuthor());
                this.writer.write("</");
                this.writer.write("author");
                this.writer.write(">");
            }
            if ((entrycnt = feed.getEntryCount()) > 0) {
                for (int x = 0; x < entrycnt; ++x) {
                    Entry entry = feed.getEntry(x);
                    this.serialize(entry);
                }
            }
            if ((contributorcnt = feed.getContributorCount()) > 0) {
                for (int x = 0; x < contributorcnt; ++x) {
                    Person contributor = feed.getContributor(x);
                    this.writer.write("<");
                    this.writer.write("contributor");
                    this.writer.write(">");
                    this.serializePerson(contributor);
                    this.writer.write("</");
                    this.writer.write("contributor");
                    this.writer.write(">");
                }
            }
            this.writer.write("</");
            this.writer.write("feed");
            this.writer.write(">");
            this.writer.flush();
        }
        catch (IOException e) {
            throw new SerializationException(e);
        }
    }
}

