/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.syntax;

import org.codehaus.groovy.syntax.LookAheadExhaustionError;
import org.codehaus.groovy.syntax.ReadException;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.TokenMismatchException;
import org.codehaus.groovy.syntax.TokenStream;

public abstract class AbstractTokenStream
implements TokenStream {
    private Token[] buf = new Token[8192];
    private int first = -1;
    private int avail = 0;
    private int checkpoint_first;
    private int checkpoint_avail;
    private String sourceLocator;

    public AbstractTokenStream() {
        this("<unknown>");
    }

    public AbstractTokenStream(String sourceLocator) {
        this.sourceLocator = sourceLocator;
    }

    public String getSourceLocator() {
        return this.sourceLocator;
    }

    protected abstract Token nextToken() throws ReadException, SyntaxException;

    public Token la() throws ReadException, SyntaxException {
        return this.la(1);
    }

    public Token la(int k) throws ReadException, SyntaxException {
        if (k > this.buf.length) {
            throw new LookAheadExhaustionError(k);
        }
        if (k > this.avail) {
            int numToPopulate = k - this.avail;
            for (int i = 0; i < numToPopulate; ++i) {
                if (this.first < 0) {
                    this.first = 0;
                }
                int pop = (this.first + this.avail) % this.buf.length;
                this.buf[pop] = this.nextToken();
                ++this.avail;
            }
        }
        int pos = (k + this.first - 1) % this.buf.length;
        return this.buf[pos];
    }

    public Token consume(int type) throws ReadException, SyntaxException {
        Token token = this.la();
        if (token.getType() != type) {
            throw new TokenMismatchException(token, type);
        }
        ++this.first;
        --this.avail;
        this.first %= this.buf.length;
        return token;
    }

    public void checkpoint() {
        this.checkpoint_first = this.first;
        this.checkpoint_avail = this.avail;
    }

    public void restore() {
        this.first = this.checkpoint_first;
        this.avail = this.checkpoint_avail;
    }

    public boolean atEnd(boolean ignoringWhitespace) {
        try {
            int offset = 1;
            if (ignoringWhitespace) {
                try {
                    while (this.la(offset).isA(5)) {
                        ++offset;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.la(offset) == null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean atEnd() {
        return this.atEnd(true);
    }
}

