/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="TypeEquals", summary="com.sun.tools.javac.code.Type doesn't override Object.equals and instances are not interned by javac, so testing types for equality should be done with Types#isSameType instead", severity=BugPattern.SeverityLevel.WARNING)
public class TypeEqualsChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final TypePredicate TYPE_MIRROR = TypePredicates.isDescendantOf((String)"javax.lang.model.type.TypeMirror");
    private static final Matcher<MethodInvocationTree> TYPE_EQUALS = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.toType(MethodInvocationTree.class, (Matcher)Matchers.instanceMethod().onClass(TYPE_MIRROR).named("equals")), Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticEqualsInvocation(), Matchers.argument((int)0, (Matcher)Matchers.typePredicateMatcher((TypePredicate)TYPE_MIRROR)), Matchers.argument((int)1, (Matcher)Matchers.typePredicateMatcher((TypePredicate)TYPE_MIRROR))})});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!TYPE_EQUALS.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree);
    }
}

