/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.tools.javac.code.Symbol;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@BugPattern(summary="This for loop increments the same variable in the header and in the body", severity=BugPattern.SeverityLevel.WARNING)
public class IncrementInForLoopAndHeader
extends BugChecker
implements BugChecker.ForLoopTreeMatcher {
    private static final ImmutableSet<Tree.Kind> CONDITIONALS = ImmutableSet.of((Object)((Object)Tree.Kind.IF), (Object)((Object)Tree.Kind.DO_WHILE_LOOP), (Object)((Object)Tree.Kind.WHILE_LOOP), (Object)((Object)Tree.Kind.FOR_LOOP), (Object)((Object)Tree.Kind.ENHANCED_FOR_LOOP));

    public Description matchForLoop(ForLoopTree forLoopTree, VisitorState visitorState) {
        List<? extends ExpressionStatementTree> updates = forLoopTree.getUpdate();
        ImmutableSet incrementedSymbols = (ImmutableSet)updates.stream().filter(expStateTree -> expStateTree.getExpression() instanceof UnaryTree).map(expStateTree -> ASTHelpers.getSymbol((Tree)((UnaryTree)expStateTree.getExpression()).getExpression())).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet());
        StatementTree body = forLoopTree.getStatement();
        List<StatementTree> statementTrees = body instanceof BlockTree ? ((BlockTree)body).getStatements() : ImmutableList.of((Object)body);
        Iterator iterator = statementTrees.iterator();
        while (iterator.hasNext()) {
            Optional<Symbol> opSymbol;
            StatementTree s = (StatementTree)iterator.next();
            if (CONDITIONALS.contains((Object)s.getKind()) || !(opSymbol = IncrementInForLoopAndHeader.returnUnarySym(s)).isPresent() || !incrementedSymbols.contains((Object)opSymbol.get())) continue;
            return this.describeMatch(forLoopTree);
        }
        return Description.NO_MATCH;
    }

    private static Optional<Symbol> returnUnarySym(StatementTree s) {
        if (s instanceof ExpressionStatementTree && ((ExpressionStatementTree)s).getExpression() instanceof UnaryTree) {
            UnaryTree unaryTree = (UnaryTree)((ExpressionStatementTree)s).getExpression();
            return Optional.ofNullable(ASTHelpers.getSymbol((Tree)unaryTree.getExpression()));
        }
        return Optional.empty();
    }
}

