/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.time;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.List;

@BugPattern(name="JodaNewPeriod", summary="This may have surprising semantics, e.g. new Period(LocalDate.parse(\"1970-01-01\"), LocalDate.parse(\"1970-02-02\")).getDays() == 1, not 32.", severity=BugPattern.SeverityLevel.WARNING)
public final class JodaNewPeriod
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String READABLE_PARTIAL = "org.joda.time.ReadablePartial";
    private static final String READABLE_INSTANT = "org.joda.time.ReadableInstant";
    private static final Matcher<MethodInvocationTree> MATCHER = Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("org.joda.time.Period").namedAnyOf(new String[]{"getMonths", "getWeeks", "getDays", "getHours", "getMinutes", "getSeconds"}), Matchers.receiverOfInvocation((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.constructor().forClass("org.joda.time.Period").withParameters("long", new String[]{"long"}), Matchers.constructor().forClass("org.joda.time.Period").withParameters("org.joda.time.ReadablePartial", new String[]{"org.joda.time.ReadablePartial"}), Matchers.constructor().forClass("org.joda.time.Period").withParameters("org.joda.time.ReadableInstant", new String[]{"org.joda.time.ReadableInstant"})}))});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return MATCHER.matches((Tree)tree, state) ? this.describeMatch(tree, (Fix)JodaNewPeriod.generateFix(tree, state)) : Description.NO_MATCH;
    }

    private static SuggestedFix generateFix(MethodInvocationTree tree, VisitorState state) {
        NewClassTree receiver = (NewClassTree)ASTHelpers.getReceiver((ExpressionTree)tree);
        List<? extends ExpressionTree> arguments = receiver.getArguments();
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((NewClassTree)receiver);
        String unit = ((MemberSelectTree)tree.getMethodSelect()).getIdentifier().toString().replace("get", "");
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        if (ASTHelpers.isSameType((Type)state.getTypes().unboxedTypeOrType(methodSymbol.params().get((int)0).type), (Type)state.getSymtab().longType, (VisitorState)state)) {
            String duration = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fixBuilder, (String)"org.joda.time.Duration");
            return fixBuilder.replace((Tree)tree, String.format("new %s(%s, %s).getStandard%s()", duration, state.getSourceForNode((Tree)arguments.get(0)), state.getSourceForNode((Tree)arguments.get(1)), unit)).build();
        }
        String unitImport = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fixBuilder, (String)("org.joda.time." + unit));
        return fixBuilder.replace((Tree)tree, String.format("%s.%sBetween(%s, %s).get%s()", unitImport, unit.toLowerCase(), state.getSourceForNode((Tree)arguments.get(0)), state.getSourceForNode((Tree)arguments.get(1)), unit)).build();
    }
}

