/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.BugPattern;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.AnnotationInfo;
import com.google.errorprone.bugpatterns.threadsafety.ImmutableAnalysis;
import com.google.errorprone.bugpatterns.threadsafety.ThreadSafety;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownMutability;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@BugPattern(name="Immutable", summary="Type declaration annotated with @Immutable is not immutable", severity=BugPattern.SeverityLevel.ERROR, documentSuppression=false)
public class ImmutableChecker
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.NewClassTreeMatcher,
BugChecker.TypeParameterTreeMatcher,
BugChecker.MethodInvocationTreeMatcher,
BugChecker.MemberReferenceTreeMatcher {
    private final WellKnownMutability wellKnownMutability;
    private final ImmutableSet<String> immutableAnnotations;

    @Deprecated
    public ImmutableChecker() {
        this(ErrorProneFlags.empty());
    }

    ImmutableChecker(ImmutableSet<String> immutableAnnotations) {
        this(ErrorProneFlags.empty(), immutableAnnotations);
    }

    public ImmutableChecker(ErrorProneFlags flags) {
        this(flags, (ImmutableSet<String>)ImmutableSet.of((Object)Immutable.class.getName()));
    }

    private ImmutableChecker(ErrorProneFlags flags, ImmutableSet<String> immutableAnnotations) {
        this.wellKnownMutability = WellKnownMutability.fromFlags(flags);
        this.immutableAnnotations = immutableAnnotations;
    }

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        return this.checkInvocation(tree, ((JCTree.JCMemberReference)tree).referentType, state, ASTHelpers.getSymbol((MemberReferenceTree)tree));
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.checkInvocation(tree, ASTHelpers.getType((Tree)tree.getMethodSelect()), state, ASTHelpers.getSymbol((MethodInvocationTree)tree));
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        this.checkInvocation(tree, ((JCTree.JCNewClass)tree).constructorType, state, ((JCTree.JCNewClass)tree).constructor);
        ImmutableAnalysis analysis = this.createImmutableAnalysis(state);
        ThreadSafety.Violation info = analysis.checkInstantiation(ASTHelpers.getSymbol((Tree)tree.getIdentifier()).getTypeParameters(), ASTHelpers.getType((Tree)tree).getTypeArguments());
        if (info.isPresent()) {
            state.reportMatch(this.buildDescription(tree).setMessage(info.message()).build());
        }
        return Description.NO_MATCH;
    }

    private ImmutableAnalysis createImmutableAnalysis(VisitorState state) {
        return new ImmutableAnalysis(this, state, this.wellKnownMutability, this.immutableAnnotations);
    }

    private Description checkInvocation(Tree tree, Type methodType, VisitorState state, Symbol symbol) {
        ImmutableAnalysis analysis = this.createImmutableAnalysis(state);
        ThreadSafety.Violation info = analysis.checkInvocation(methodType, symbol);
        if (info.isPresent()) {
            state.reportMatch(this.buildDescription(tree).setMessage(info.message()).build());
        }
        return Description.NO_MATCH;
    }

    public Description matchTypeParameter(TypeParameterTree tree, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        ImmutableAnalysis analysis = this.createImmutableAnalysis(state);
        if (!analysis.hasThreadSafeTypeParameterAnnotation((Symbol.TypeVariableSymbol)sym)) {
            return Description.NO_MATCH;
        }
        switch (sym.owner.getKind()) {
            case METHOD: 
            case CONSTRUCTOR: {
                return Description.NO_MATCH;
            }
        }
        AnnotationInfo info = analysis.getImmutableAnnotation(sym.owner, state);
        if (info == null) {
            return this.buildDescription(tree).setMessage("@Immutable is only supported on immutable classes").build();
        }
        return Description.NO_MATCH;
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        ImmutableAnalysis analysis = this.createImmutableAnalysis(state);
        if (tree.getSimpleName().length() == 0) {
            return this.handleAnonymousClass(tree, state, analysis);
        }
        AnnotationInfo annotation = analysis.getImmutableAnnotation(tree, state);
        if (annotation == null) {
            return this.checkSubtype(tree, state);
        }
        if (this.wellKnownMutability.getKnownImmutableClasses().containsValue(annotation)) {
            return Description.NO_MATCH;
        }
        HashMap<String, Symbol.TypeVariableSymbol> typarams = new HashMap<String, Symbol.TypeVariableSymbol>();
        for (TypeParameterTree typeParameterTree : tree.getTypeParameters()) {
            typarams.put(typeParameterTree.getName().toString(), (Symbol.TypeVariableSymbol)ASTHelpers.getSymbol((Tree)typeParameterTree));
        }
        Sets.SetView difference = Sets.difference(annotation.containerOf(), typarams.keySet());
        if (!difference.isEmpty()) {
            return this.buildDescription(tree).setMessage(String.format("could not find type(s) referenced by containerOf: %s", Joiner.on((String)"', '").join((Iterable)difference))).build();
        }
        ImmutableSet immutableSet = (ImmutableSet)typarams.entrySet().stream().filter(e -> annotation.containerOf().contains(e.getKey()) && analysis.hasThreadSafeTypeParameterAnnotation((Symbol.TypeVariableSymbol)e.getValue())).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
        if (!immutableSet.isEmpty()) {
            return this.buildDescription(tree).setMessage(String.format("using both @ImmutableTypeParameter and containerOf is redundant: %s", Joiner.on((String)"', '").join((Iterable)immutableSet))).build();
        }
        Symbol.ClassSymbol sym = ASTHelpers.getSymbol((ClassTree)tree);
        ThreadSafety.Violation info = analysis.checkForImmutability(Optional.of(tree), ImmutableChecker.immutableTypeParametersInScope(ASTHelpers.getSymbol((ClassTree)tree), state, analysis), ASTHelpers.getType((ClassTree)tree), (matched, violation) -> this.describeClass(matched, sym, annotation, violation));
        if (!info.isPresent()) {
            return Description.NO_MATCH;
        }
        return this.describeClass(tree, sym, annotation, info).build();
    }

    private Description.Builder describeClass(Tree tree, Symbol.ClassSymbol sym, AnnotationInfo annotation, ThreadSafety.Violation info) {
        Object message = sym.getQualifiedName().contentEquals(annotation.typeName()) ? "type annotated with @Immutable could not be proven immutable: " + info.message() : String.format("Class extends @Immutable type %s, but is not immutable: %s", annotation.typeName(), info.message());
        return this.buildDescription(tree).setMessage((String)message);
    }

    private Description handleAnonymousClass(ClassTree tree, VisitorState state, ImmutableAnalysis analysis) {
        Symbol.ClassSymbol sym = ASTHelpers.getSymbol((ClassTree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        final Type superType = this.immutableSupertype(sym, state);
        if (superType == null) {
            return Description.NO_MATCH;
        }
        ImmutableSet<String> typarams = ImmutableChecker.immutableTypeParametersInScope(sym, state, analysis);
        ThreadSafety.Violation info = analysis.areFieldsImmutable(Optional.of(tree), typarams, ASTHelpers.getType((ClassTree)tree), new ImmutableAnalysis.ViolationReporter(){

            @Override
            public Description.Builder describe(Tree tree, ThreadSafety.Violation info) {
                return ImmutableChecker.this.describeAnonymous(tree, superType, info);
            }
        });
        if (!info.isPresent()) {
            return Description.NO_MATCH;
        }
        return this.describeAnonymous(tree, superType, info).build();
    }

    private Description.Builder describeAnonymous(Tree tree, Type superType, ThreadSafety.Violation info) {
        String message = String.format("Class extends @Immutable type %s, but is not immutable: %s", superType, info.message());
        return this.buildDescription(tree).setMessage(message);
    }

    private Description checkSubtype(ClassTree tree, VisitorState state) {
        Symbol.ClassSymbol sym = ASTHelpers.getSymbol((ClassTree)tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        Type superType = this.immutableSupertype(sym, state);
        if (superType == null) {
            return Description.NO_MATCH;
        }
        String message = String.format("Class extends @Immutable type %s, but is not annotated as immutable", superType);
        SuggestedFix fix = SuggestedFix.builder().prefixWith((Tree)tree, "@Immutable ").addImport(Immutable.class.getName()).build();
        return this.buildDescription(tree).setMessage(message).addFix((Fix)fix).build();
    }

    private Type immutableSupertype(Symbol sym, VisitorState state) {
        for (Type superType : state.getTypes().closure(sym.type)) {
            if (superType.tsym.equals(sym.type.tsym) || !this.immutableAnnotations.stream().anyMatch(annotation -> ASTHelpers.hasAnnotation((Symbol)superType.tsym, (String)annotation, (VisitorState)state))) continue;
            return superType;
        }
        return null;
    }

    private static ImmutableSet<String> immutableTypeParametersInScope(Symbol sym, VisitorState state, ImmutableAnalysis analysis) {
        if (sym == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder result = ImmutableSet.builder();
        Symbol s = sym;
        block4: while (s.owner != null) {
            switch (s.getKind()) {
                case INSTANCE_INIT: {
                    break;
                }
                case PACKAGE: {
                    break block4;
                }
                default: {
                    AnnotationInfo annotation = analysis.getImmutableAnnotation(s, state);
                    if (annotation == null) break;
                    for (Symbol.TypeVariableSymbol typaram : s.getTypeParameters()) {
                        String name = ((Name)typaram.getSimpleName()).toString();
                        if (!annotation.containerOf().contains(name)) continue;
                        result.add((Object)name);
                    }
                    if (s.isStatic()) break block4;
                }
            }
            s = s.owner;
        }
        return result.build();
    }
}

