/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.writer.KCode;
import java.util.List;

public class InstanceOfExpr
extends Expr {
    final String mTypeStr;
    ModelClass mType;

    InstanceOfExpr(Expr left, String type) {
        super(left);
        this.mTypeStr = type;
    }

    @Override
    protected String computeUniqueKey() {
        return InstanceOfExpr.join(this.getExpr(), "instanceof", this.mTypeStr);
    }

    @Override
    protected KCode generateCode() {
        return new KCode().app("", this.getExpr().toCode()).app(" instanceof ").app(this.getType().toJavaCode());
    }

    @Override
    public void injectSafeUnboxing(ModelAnalyzer modelAnalyzer, ExprModel model) {
    }

    @Override
    public Expr cloneToModel(ExprModel model) {
        return model.instanceOfOp(this.getExpr().cloneToModel(model), this.mTypeStr);
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        this.mType = modelAnalyzer.findClass(this.mTypeStr, this.getModel().getImports());
        return modelAnalyzer.loadPrimitive("boolean");
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return this.constructDynamicChildrenDependencies();
    }

    public Expr getExpr() {
        return this.getChildren().get(0);
    }

    public ModelClass getType() {
        return this.mType;
    }

    @Override
    public String getInvertibleError() {
        return "two-way binding can't target a value with the 'instanceof' operator";
    }

    @Override
    public String toString() {
        return this.getExpr().toString() + " instanceof " + this.mTypeStr;
    }
}

