/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.diag;

import com.google.common.collect.ImmutableList;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineDiagnostic;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;

public class TurbineError
extends Error {
    private final ImmutableList<TurbineDiagnostic> diagnostics;

    public static TurbineError format(SourceFile source, ErrorKind kind, Object ... args) {
        return new TurbineError((ImmutableList<TurbineDiagnostic>)ImmutableList.of((Object)TurbineDiagnostic.format(source, kind, args)));
    }

    public static TurbineError format(SourceFile source, int position, ErrorKind kind, Object ... args) {
        return new TurbineError((ImmutableList<TurbineDiagnostic>)ImmutableList.of((Object)TurbineDiagnostic.format(Diagnostic.Kind.ERROR, source, position, kind, args)));
    }

    public TurbineError(ImmutableList<TurbineDiagnostic> diagnostics) {
        this.diagnostics = diagnostics;
    }

    @Override
    public String getMessage() {
        return this.diagnostics.stream().map(d -> d.diagnostic()).collect(Collectors.joining(System.lineSeparator()));
    }

    public ImmutableList<TurbineDiagnostic> diagnostics() {
        return this.diagnostics;
    }

    public static enum ErrorKind {
        UNEXPECTED_INPUT("unexpected input: %c"),
        UNEXPECTED_IDENTIFIER("unexpected identifier '%s'"),
        UNEXPECTED_EOF("unexpected end of input"),
        UNTERMINATED_STRING("unterminated string literal"),
        UNTERMINATED_CHARACTER_LITERAL("unterminated char literal"),
        UNTERMINATED_EXPRESSION("unterminated expression, expected ';' not found"),
        INVALID_UNICODE("illegal unicode escape"),
        EMPTY_CHARACTER_LITERAL("empty char literal"),
        EXPECTED_TOKEN("expected token %s"),
        EXTENDS_AFTER_IMPLEMENTS("'extends' must come before 'implements'"),
        INVALID_LITERAL("invalid literal: %s"),
        UNEXPECTED_TYPE_PARAMETER("unexpected type parameter %s"),
        SYMBOL_NOT_FOUND("symbol not found %s"),
        CLASS_FILE_NOT_FOUND("could not locate class file for %s"),
        TYPE_PARAMETER_QUALIFIER("type parameter used as type qualifier"),
        UNEXPECTED_TOKEN("unexpected token: %s"),
        INVALID_ANNOTATION_ARGUMENT("invalid annotation argument"),
        MISSING_ANNOTATION_ARGUMENT("missing required annotation argument: %s"),
        CANNOT_RESOLVE("could not resolve %s"),
        EXPRESSION_ERROR("could not evaluate constant expression"),
        OPERAND_TYPE("bad operand type %s"),
        CYCLIC_HIERARCHY("cycle in class hierarchy: %s"),
        NOT_AN_ANNOTATION("%s is not an annotation"),
        NONREPEATABLE_ANNOTATION("%s is not @Repeatable"),
        DUPLICATE_DECLARATION("duplicate declaration of %s"),
        BAD_MODULE_INFO("unexpected declaration found in module-info"),
        UNCLOSED_COMMENT("unclosed comment"),
        UNEXPECTED_TYPE("unexpected type %s"),
        UNEXPECTED_MODIFIER("unexpected modifier: %s"),
        PROC("%s");

        private final String message;

        private ErrorKind(String message) {
            this.message = message;
        }

        String format(Object ... args) {
            return String.format(this.message, args);
        }
    }
}

