/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.client;

import com.sun.tools.javac.main.Main;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.client.PortFileInaccessibleException;
import com.sun.tools.sjavac.options.OptionHelper;
import com.sun.tools.sjavac.options.Options;
import com.sun.tools.sjavac.server.PortFile;
import com.sun.tools.sjavac.server.Sjavac;
import com.sun.tools.sjavac.server.SjavacServer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class SjavacClient
implements Sjavac {
    private final String id;
    private final PortFile portFile;
    private final int keepalive;
    private final int poolsize;
    private final String sjavacForkCmd;
    static int CONNECTION_TIMEOUT = 2000;
    static int MAX_CONNECT_ATTEMPTS = 3;
    static int WAIT_BETWEEN_CONNECT_ATTEMPTS = 2000;
    private final String settings;

    public SjavacClient(Options options) {
        String tmpServerConf = options.getServerConf();
        String serverConf = tmpServerConf != null ? tmpServerConf : "";
        String tmpId = Util.extractStringOption("id", serverConf);
        this.id = tmpId != null ? tmpId : "id" + (new Random().nextLong() & Long.MAX_VALUE);
        String defaultPortfile = options.getDestDir().resolve("javac_server").toAbsolutePath().toString();
        String portfileName = Util.extractStringOption("portfile", serverConf, defaultPortfile);
        this.portFile = SjavacServer.getPortFile(portfileName);
        this.sjavacForkCmd = Util.extractStringOption("sjavac", serverConf, "sjavac");
        int poolsize = Util.extractIntOption("poolsize", serverConf);
        this.keepalive = Util.extractIntOption("keepalive", serverConf, 120);
        this.poolsize = poolsize > 0 ? poolsize : Runtime.getRuntime().availableProcessors();
        this.settings = serverConf.equals("") ? "id=" + this.id + ",portfile=" + portfileName : serverConf;
    }

    public String serverSettings() {
        return this.settings;
    }

    @Override
    public Main.Result compile(String[] args) {
        Main.Result result = null;
        try (Socket socket = this.tryConnect();){
            String line;
            PrintWriter out = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            out.println(args.length);
            for (String arg : args) {
                out.println(arg);
            }
            out.flush();
            while (null != (line = in.readLine())) {
                if (!line.contains(":")) {
                    throw new AssertionError((Object)("Could not parse protocol line: >>\"" + line + "\"<<"));
                }
                String[] typeAndContent = line.split(":", 2);
                String type = typeAndContent[0];
                Object content = typeAndContent[1];
                try {
                    if (Log.isDebugging()) {
                        content = "[sjavac-server] " + (String)content;
                    }
                    Log.log(Log.Level.valueOf(type), (String)content);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!type.equals("RC")) continue;
                    result = Main.Result.valueOf((String)content);
                }
            }
        }
        catch (PortFileInaccessibleException e) {
            Log.error("Port file inaccessible.");
            result = Main.Result.ERROR;
        }
        catch (IOException ioe) {
            Log.error("IOException caught during compilation: " + ioe.getMessage());
            Log.debug(ioe);
            result = Main.Result.ERROR;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            Log.error("Compilation interrupted.");
            Log.debug(ie);
            result = Main.Result.ERROR;
        }
        if (result == null) {
            result = Main.Result.ERROR;
        }
        return result;
    }

    private Socket tryConnect() throws IOException, InterruptedException {
        this.makeSureServerIsRunning(this.portFile);
        int attempt = 0;
        while (true) {
            Log.debug("Trying to connect. Attempt " + ++attempt + " of " + MAX_CONNECT_ATTEMPTS);
            try {
                return this.makeConnectionAttempt();
            }
            catch (IOException ex) {
                Log.error("Connection attempt failed: " + ex.getMessage());
                if (attempt >= MAX_CONNECT_ATTEMPTS) {
                    Log.error("Giving up");
                    throw new IOException("Could not connect to server", ex);
                }
                Thread.sleep(WAIT_BETWEEN_CONNECT_ATTEMPTS);
                continue;
            }
            break;
        }
    }

    private Socket makeConnectionAttempt() throws IOException {
        Socket socket = new Socket();
        InetAddress localhost = InetAddress.getByName(null);
        InetSocketAddress address = new InetSocketAddress(localhost, this.portFile.getPort());
        socket.connect(address, CONNECTION_TIMEOUT);
        Log.debug("Connected");
        return socket;
    }

    private void makeSureServerIsRunning(PortFile portFile) throws IOException, InterruptedException {
        if (portFile.exists()) {
            portFile.lock();
            portFile.getValues();
            portFile.unlock();
            if (portFile.containsPortInfo()) {
                return;
            }
        }
        SjavacClient.fork(this.sjavacForkCmd, portFile, this.poolsize, this.keepalive);
    }

    @Override
    public void shutdown() {
    }

    public static void fork(String sjavacCmd, PortFile portFile, int poolsize, int keepalive) throws IOException, InterruptedException {
        Process serverProcess;
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.addAll(Arrays.asList(OptionHelper.unescapeCmdArg(sjavacCmd).split(" ")));
        cmd.add("--startserver:portfile=" + portFile.getFilename() + ",poolsize=" + poolsize + ",keepalive=" + keepalive);
        Log.debug("Starting server. Command: " + String.join((CharSequence)" ", cmd));
        try {
            serverProcess = new ProcessBuilder(cmd).redirectErrorStream(true).start();
        }
        catch (IOException ex) {
            Log.error("Failed to create server process: " + ex.getMessage());
            Log.debug(ex);
            throw new IOException(ex);
        }
        try {
            portFile.waitForValidValues();
        }
        catch (IOException ex) {
            Log.error("Sjavac server failed to initialize: " + ex.getMessage());
            Log.error("Process output:");
            InputStreamReader serverStdoutStderr = new InputStreamReader(serverProcess.getInputStream());
            try (BufferedReader br = new BufferedReader(serverStdoutStderr);){
                br.lines().forEach(Log::error);
            }
            Log.error("<End of process output>");
            try {
                Log.error("Process exit code: " + serverProcess.exitValue());
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
            throw new IOException("Server failed to initialize: " + ex.getMessage(), ex);
        }
    }
}

