/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.writer;

import java.util.BitSet;

public class FlagSet {
    public static final int sBucketSize = 64;
    public final String type;
    public final long[] buckets;
    private String mLocalName;
    private boolean mIsDynamic = false;

    public FlagSet(BitSet bitSet, int bucketCount) {
        this.buckets = new long[bucketCount];
        int i = bitSet.nextSetBit(0);
        while (i != -1) {
            int n = i / 64;
            this.buckets[n] = this.buckets[n] | 1L << i % 64;
            i = bitSet.nextSetBit(i + 1);
        }
        this.type = "long";
    }

    public FlagSet(long[] buckets) {
        this.buckets = new long[buckets.length];
        System.arraycopy(buckets, 0, this.buckets, 0, buckets.length);
        this.type = "long";
    }

    public FlagSet(long[] buckets, int minBucketCount) {
        this.buckets = new long[Math.max(buckets.length, minBucketCount)];
        System.arraycopy(buckets, 0, this.buckets, 0, buckets.length);
        this.type = "long";
    }

    public FlagSet(int ... bits) {
        int max = 0;
        for (int i = 0; i < bits.length; ++i) {
            max = Math.max(i, bits[i]);
        }
        this.buckets = new long[1 + max / 64];
        for (int x = 0; x < bits.length; ++x) {
            int i = bits[x];
            int n = i / 64;
            this.buckets[n] = this.buckets[n] | 1L << i % 64;
        }
        this.type = "long";
    }

    public boolean intersect(FlagSet other, int bucketIndex) {
        return (this.buckets[bucketIndex] & other.buckets[bucketIndex]) != 0L;
    }

    public String getLocalName() {
        return this.mLocalName;
    }

    public void setLocalName(String localName) {
        this.mLocalName = localName;
    }

    public boolean hasLocalName() {
        return this.mLocalName != null;
    }

    public boolean isDynamic() {
        return this.mIsDynamic;
    }

    public void setDynamic(boolean isDynamic) {
        this.mIsDynamic = isDynamic;
    }

    public FlagSet andNot(FlagSet other) {
        FlagSet result = new FlagSet(this.buckets);
        int min = Math.min(this.buckets.length, other.buckets.length);
        for (int i = 0; i < min; ++i) {
            int n = i;
            result.buckets[n] = result.buckets[n] & (other.buckets[i] ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return result;
    }

    public FlagSet or(FlagSet other) {
        FlagSet result = new FlagSet(this.buckets, other.buckets.length);
        for (int i = 0; i < other.buckets.length; ++i) {
            int n = i;
            result.buckets[n] = result.buckets[n] | other.buckets[i];
        }
        return result;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.buckets.length; ++i) {
            if (this.buckets[i] == 0L) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.buckets.length; ++i) {
            sb.append(Long.toBinaryString(this.buckets[i])).append(" ");
        }
        return sb.toString();
    }

    private long getBucket(int bucketIndex) {
        if (bucketIndex >= this.buckets.length) {
            return 0L;
        }
        return this.buckets[bucketIndex];
    }

    public boolean bitsEqual(FlagSet other) {
        int max = Math.max(this.buckets.length, other.buckets.length);
        for (int i = 0; i < max; ++i) {
            if (this.getBucket(i) == other.getBucket(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 1;
        for (long bucket : this.buckets) {
            hash = hash * 7 ^ (int)(bucket >>> 32);
            hash = hash * 13 ^ (int)(bucket & 0xFFFFL);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FlagSet) {
            FlagSet other = (FlagSet)obj;
            if (other.buckets.length != this.buckets.length) {
                return false;
            }
            for (int i = 0; i < this.buckets.length; ++i) {
                if (this.buckets[i] == other.buckets[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

