/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.ImmutableTypeParameter;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.AnnotationInfo;
import com.google.errorprone.bugpatterns.threadsafety.ThreadSafety;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownMutability;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Filter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;

public class ImmutableAnalysis {
    private final BugChecker bugChecker;
    private final VisitorState state;
    private final WellKnownMutability wellKnownMutability;
    private final ThreadSafety threadSafety;

    ImmutableAnalysis(BugChecker bugChecker, VisitorState state, WellKnownMutability wellKnownMutability, ImmutableSet<String> immutableAnnotations) {
        this.bugChecker = bugChecker;
        this.state = state;
        this.wellKnownMutability = wellKnownMutability;
        this.threadSafety = ThreadSafety.builder().setPurpose(ThreadSafety.Purpose.FOR_IMMUTABLE_CHECKER).knownTypes(wellKnownMutability).markerAnnotations(immutableAnnotations).typeParameterAnnotation(ImmutableTypeParameter.class).build(state);
    }

    public ImmutableAnalysis(BugChecker bugChecker, VisitorState state, WellKnownMutability wellKnownMutability) {
        this(bugChecker, state, wellKnownMutability, (ImmutableSet<String>)ImmutableSet.of((Object)Immutable.class.getName()));
    }

    ThreadSafety.Violation isThreadSafeType(boolean allowContainerTypeParameters, Set<String> containerTypeParameters, Type type) {
        return this.threadSafety.isThreadSafeType(allowContainerTypeParameters, containerTypeParameters, type);
    }

    boolean hasThreadSafeTypeParameterAnnotation(Symbol.TypeVariableSymbol sym) {
        return this.threadSafety.hasThreadSafeTypeParameterAnnotation(sym);
    }

    ThreadSafety.Violation checkInstantiation(Collection<Symbol.TypeVariableSymbol> classTypeParameters, Collection<Type> typeArguments) {
        return this.threadSafety.checkInstantiation(classTypeParameters, typeArguments);
    }

    public ThreadSafety.Violation checkInvocation(Type methodType, Symbol symbol) {
        return this.threadSafety.checkInvocation(methodType, symbol);
    }

    public ThreadSafety.Violation checkForImmutability(Optional<ClassTree> tree, ImmutableSet<String> immutableTyParams, Type.ClassType type, ViolationReporter reporter) {
        ThreadSafety.Violation info = this.areFieldsImmutable(tree, immutableTyParams, type, reporter);
        if (info.isPresent()) {
            return info;
        }
        for (Type interfaceType : this.state.getTypes().interfaces(type)) {
            AnnotationInfo interfaceAnnotation = this.getImmutableAnnotation(interfaceType.tsym, this.state);
            if (interfaceAnnotation == null || !(info = this.threadSafety.checkSuperInstantiation((Set<String>)immutableTyParams, interfaceAnnotation, interfaceType)).isPresent()) continue;
            return info.plus(String.format("'%s' extends '%s'", this.threadSafety.getPrettyName(type.tsym), this.threadSafety.getPrettyName(interfaceType.tsym)));
        }
        if (!((Symbol)type.asElement()).isEnum() && (info = this.checkSuper(immutableTyParams, type)).isPresent()) {
            return info;
        }
        Type mutableEnclosing = this.threadSafety.mutableEnclosingInstance(tree, type);
        if (mutableEnclosing != null) {
            return info.plus(String.format("'%s' has mutable enclosing instance '%s'", this.threadSafety.getPrettyName(type.tsym), mutableEnclosing));
        }
        return ThreadSafety.Violation.absent();
    }

    private ThreadSafety.Violation checkSuper(ImmutableSet<String> immutableTyParams, Type.ClassType type) {
        Type.ClassType superType = (Type.ClassType)this.state.getTypes().supertype(type);
        if (superType.getKind() == TypeKind.NONE || this.state.getTypes().isSameType(this.state.getSymtab().objectType, superType)) {
            return ThreadSafety.Violation.absent();
        }
        if (WellKnownMutability.isAnnotation(this.state, type)) {
            return ThreadSafety.Violation.absent();
        }
        AnnotationInfo superannotation = this.getImmutableAnnotation(superType.tsym, this.state);
        String message = String.format("'%s' extends '%s'", this.threadSafety.getPrettyName(type.tsym), this.threadSafety.getPrettyName(superType.tsym));
        if (superannotation != null) {
            ThreadSafety.Violation info = this.threadSafety.checkSuperInstantiation((Set<String>)immutableTyParams, superannotation, superType);
            if (!info.isPresent()) {
                return ThreadSafety.Violation.absent();
            }
            return info.plus(message);
        }
        ThreadSafety.Violation info = this.checkForImmutability(Optional.empty(), immutableTyParams, superType, new ViolationReporter(){

            @Override
            public Description.Builder describe(Tree tree, ThreadSafety.Violation info) {
                return ImmutableAnalysis.this.bugChecker.buildDescription(tree).setMessage(info.plus(info.message()).message());
            }
        });
        if (!info.isPresent()) {
            return ThreadSafety.Violation.absent();
        }
        return info.plus(message);
    }

    ThreadSafety.Violation areFieldsImmutable(Optional<ClassTree> tree, ImmutableSet<String> immutableTyParams, Type.ClassType classType, ViolationReporter reporter) {
        Symbol.ClassSymbol classSym = (Symbol.ClassSymbol)classType.tsym;
        if (classSym.members() == null) {
            return ThreadSafety.Violation.absent();
        }
        Filter<Symbol> instanceFieldFilter = new Filter<Symbol>(){

            public boolean accepts(Symbol symbol) {
                return symbol.getKind() == ElementKind.FIELD && !symbol.isStatic();
            }
        };
        HashMap<Symbol, Tree> declarations = new HashMap<Symbol, Tree>();
        if (tree.isPresent()) {
            for (Tree tree2 : tree.get().getMembers()) {
                Symbol sym = ASTHelpers.getSymbol((Tree)tree2);
                if (sym == null) continue;
                declarations.put(sym, tree2);
            }
        }
        ImmutableList members = ImmutableList.copyOf((Iterable)classSym.members().getSymbols((Filter)instanceFieldFilter)).reverse();
        for (Symbol member : members) {
            Optional<Tree> memberTree = Optional.ofNullable(declarations.get(member));
            ThreadSafety.Violation info = this.isFieldImmutable(memberTree, immutableTyParams, classSym, classType, (Symbol.VarSymbol)member, reporter);
            if (!info.isPresent()) continue;
            return info;
        }
        return ThreadSafety.Violation.absent();
    }

    private ThreadSafety.Violation isFieldImmutable(Optional<Tree> tree, ImmutableSet<String> immutableTyParams, Symbol.ClassSymbol classSym, Type.ClassType classType, Symbol.VarSymbol var, ViolationReporter reporter) {
        if (this.bugChecker.isSuppressed((Symbol)var)) {
            return ThreadSafety.Violation.absent();
        }
        if (!var.getModifiers().contains((Object)Modifier.FINAL) && !ASTHelpers.hasAnnotation((Symbol)var, LazyInit.class, (VisitorState)this.state)) {
            ThreadSafety.Violation info = ThreadSafety.Violation.of(String.format("'%s' has non-final field '%s'", this.threadSafety.getPrettyName(classSym), var.getSimpleName()));
            if (tree.isPresent()) {
                this.state.reportMatch(reporter.report(tree.get(), info, SuggestedFixes.addModifiers((Tree)tree.get(), (VisitorState)this.state, (Modifier[])new Modifier[]{Modifier.FINAL})));
                return ThreadSafety.Violation.absent();
            }
            return info;
        }
        Type varType = this.state.getTypes().memberType(classType, var);
        ThreadSafety.Violation info = this.threadSafety.isThreadSafeType(true, (Set<String>)immutableTyParams, varType);
        if (info.isPresent()) {
            info = info.plus(String.format("'%s' has field '%s' of type '%s'", this.threadSafety.getPrettyName(classSym), var.getSimpleName(), varType));
            if (tree.isPresent()) {
                this.state.reportMatch(reporter.report(tree.get(), info, Optional.empty()));
                return ThreadSafety.Violation.absent();
            }
            return info;
        }
        return ThreadSafety.Violation.absent();
    }

    AnnotationInfo getImmutableAnnotation(Symbol sym, VisitorState state) {
        String nameStr = sym.flatName().toString();
        AnnotationInfo known = this.wellKnownMutability.getKnownImmutableClasses().get(nameStr);
        if (known != null) {
            return known;
        }
        return this.threadSafety.getInheritedAnnotation(sym, state);
    }

    AnnotationInfo getImmutableAnnotation(Tree tree, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        return sym == null ? null : this.threadSafety.getMarkerOrAcceptedAnnotation(sym, state);
    }

    @FunctionalInterface
    public static interface ViolationReporter {
        public Description.Builder describe(Tree var1, ThreadSafety.Violation var2);

        @CheckReturnValue
        default public Description report(Tree tree, ThreadSafety.Violation info, Optional<SuggestedFix> suggestedFix) {
            Description.Builder description = this.describe(tree, info);
            suggestedFix.ifPresent(arg_0 -> ((Description.Builder)description).addFix(arg_0));
            return description.build();
        }
    }
}

