/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Ascii;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.ImmutableCollections;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(name="MutableConstantField", summary="Constant field declarations should use the immutable type (such as ImmutableList) instead of the general collection interface type (such as List)", severity=BugPattern.SeverityLevel.WARNING)
public final class MutableConstantField
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final String BIND = "com.google.inject.testing.fieldbinder.Bind";
    private static final MultiMatcher<VariableTree, AnnotationTree> VAR_TO_BIND_ANNOTATION = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)Matchers.isSameType((String)"com.google.inject.testing.fieldbinder.Bind"));

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (!MutableConstantField.isConstantField(ASTHelpers.getSymbol((VariableTree)tree))) {
            return Description.NO_MATCH;
        }
        ExpressionTree rhsTree = tree.getInitializer();
        Type rhsType = ASTHelpers.getType((Tree)rhsTree);
        if (rhsType == null || !ImmutableCollections.isImmutableType(rhsType)) {
            return Description.NO_MATCH;
        }
        Tree lhsTree = tree.getType();
        Type lhsType = ASTHelpers.getType((Tree)lhsTree);
        if (lhsType == null || ImmutableCollections.isImmutableType(lhsType)) {
            return Description.NO_MATCH;
        }
        MultiMatcher.MultiMatchResult hasBindAnnotations = VAR_TO_BIND_ANNOTATION.multiMatchResult((Tree)tree, state);
        if (hasBindAnnotations.matches()) {
            return Description.NO_MATCH;
        }
        String lhsTypeQualifiedName = MutableConstantField.getTypeQualifiedName(lhsType);
        String newLhsTypeQualifiedName = ImmutableCollections.mutableToImmutable(lhsTypeQualifiedName).orElse(MutableConstantField.getTypeQualifiedName(rhsType));
        Type newLhsType = state.getTypeFromString(newLhsTypeQualifiedName);
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        fixBuilder.replace(ASTHelpers.getErasedTypeTree((Tree)lhsTree), SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fixBuilder, (Symbol)newLhsType.asElement()));
        SuggestedFix fix = fixBuilder.build();
        return this.describeMatch(lhsTree, (Fix)fix);
    }

    private static String getTypeQualifiedName(Type type) {
        return type.tsym.getQualifiedName().toString();
    }

    private static boolean isConstantField(Symbol sym) {
        return sym.getKind() == ElementKind.FIELD && MutableConstantField.isStaticFinalField(sym) && MutableConstantField.isConstantFieldName(sym.getSimpleName().toString());
    }

    private static boolean isStaticFinalField(Symbol sym) {
        return sym.isStatic() && sym.getModifiers().contains((Object)Modifier.FINAL);
    }

    private static boolean isConstantFieldName(String fieldName) {
        return Ascii.toUpperCase((String)fieldName).equals(fieldName);
    }
}

