/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.names;

import com.google.common.base.Ascii;
import com.google.common.primitives.Ints;

public class LevenshteinEditDistance {
    private LevenshteinEditDistance() {
    }

    public static int getEditDistance(String source, String target) {
        return LevenshteinEditDistance.getEditDistance(source, target, true);
    }

    public static int getEditDistance(String source, String target, boolean caseSensitive) {
        int i;
        int targetLength;
        int sourceLength = LevenshteinEditDistance.isEmptyOrWhitespace(source) ? 0 : source.length();
        int n = targetLength = LevenshteinEditDistance.isEmptyOrWhitespace(target) ? 0 : target.length();
        if (sourceLength == 0) {
            return targetLength;
        }
        if (targetLength == 0) {
            return sourceLength;
        }
        if (!caseSensitive) {
            source = Ascii.toLowerCase((String)source);
            target = Ascii.toLowerCase((String)target);
        }
        int[][] levMatrix = new int[sourceLength + 1][targetLength + 1];
        for (i = 0; i <= sourceLength; ++i) {
            levMatrix[i][0] = i;
        }
        for (i = 0; i <= targetLength; ++i) {
            levMatrix[0][i] = i;
        }
        for (i = 1; i <= sourceLength; ++i) {
            char sourceI = source.charAt(i - 1);
            for (int j = 1; j <= targetLength; ++j) {
                char targetJ = target.charAt(j - 1);
                int cost = 0;
                if (sourceI != targetJ) {
                    cost = 1;
                }
                levMatrix[i][j] = Ints.min((int[])new int[]{cost + levMatrix[i - 1][j - 1], levMatrix[i - 1][j] + 1, levMatrix[i][j - 1] + 1});
            }
        }
        return levMatrix[sourceLength][targetLength];
    }

    public static double getNormalizedEditDistance(String source, String target, boolean caseSensitive) {
        if (LevenshteinEditDistance.isEmptyOrWhitespace(source) && LevenshteinEditDistance.isEmptyOrWhitespace(target)) {
            return 0.0;
        }
        return (double)LevenshteinEditDistance.getEditDistance(source, target, caseSensitive) / (double)LevenshteinEditDistance.getWorstCaseEditDistance(source.length(), target.length());
    }

    public static int getWorstCaseEditDistance(int sourceLength, int targetLength) {
        return Math.max(sourceLength, targetLength);
    }

    private static boolean isEmptyOrWhitespace(String source) {
        return source == null || source.matches("\\s*");
    }
}

