/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.CaseFormat;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;

@BugPattern(name="ConstantPatternCompile", summary="Variables initialized with Pattern#compile calls on constants can be constants", severity=BugPattern.SeverityLevel.SUGGESTION)
public final class ConstantPatternCompile
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final String PATTERN_CLASS = "java.util.regex.Pattern";
    private static final Supplier<Type> PATTERN_TYPE = Suppliers.typeFromString((String)"java.util.regex.Pattern");
    private static final Matcher<ExpressionTree> PATTERN_COMPILE_CHECK = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("java.util.regex.Pattern").named("compile")});

    public Description matchVariable(VariableTree tree, VisitorState state) {
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent instanceof ClassTree) {
            return Description.NO_MATCH;
        }
        if (!ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)tree.getType()), (Type)((Type)PATTERN_TYPE.get(state)), (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        if (!(tree.getInitializer() instanceof MethodInvocationTree)) {
            return Description.NO_MATCH;
        }
        MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree.getInitializer();
        if (!PATTERN_COMPILE_CHECK.matches((Tree)methodInvocationTree, state)) {
            return Description.NO_MATCH;
        }
        if (methodInvocationTree.getArguments().stream().noneMatch(ConstantPatternCompile::isArgStaticAndConstant)) {
            return Description.NO_MATCH;
        }
        MethodTree outerMethodTree = (MethodTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), MethodTree.class);
        if (outerMethodTree == null) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol((MethodTree)outerMethodTree);
        boolean canUseStatic = sym != null && sym.owner.enclClass().getNestingKind() == NestingKind.TOP_LEVEL || outerMethodTree.getModifiers().getFlags().contains((Object)Modifier.STATIC);
        String originalVariableTreeString = state.getSourceForNode((Tree)tree);
        String varName = tree.getName().toString();
        String upperUnderscoreVarName = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, varName);
        int typeEndPos = state.getEndPosition(tree.getType());
        int searchOffset = typeEndPos == -1 ? 0 : typeEndPos - ((JCTree)((Object)tree)).getStartPosition();
        int pos = state.getSourceForNode((Tree)tree).indexOf(varName, searchOffset);
        String variableReplacedString = new StringBuilder(originalVariableTreeString).replace(pos, pos + varName.length(), upperUnderscoreVarName).toString();
        String modifiers = canUseStatic ? "static final " : "final ";
        String variableTreeString = modifiers + variableReplacedString;
        SuggestedFix fix = SuggestedFix.builder().merge(ConstantPatternCompile.renameVariableOccurrences(tree, upperUnderscoreVarName, state)).prefixWith((Tree)outerMethodTree, variableTreeString).delete((Tree)tree).build();
        return this.describeMatch(tree, (Fix)fix);
    }

    private static boolean isArgStaticAndConstant(ExpressionTree arg) {
        if (ASTHelpers.constValue((Tree)arg) == null) {
            return false;
        }
        Symbol argSymbol = ASTHelpers.getSymbol((Tree)arg);
        if (argSymbol == null) {
            return true;
        }
        return (argSymbol.flags() & 8L) != 0L;
    }

    private static SuggestedFix renameVariableOccurrences(VariableTree tree, final String replacement, final VisitorState state) {
        final SuggestedFix.Builder fix = SuggestedFix.builder();
        final Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)tree);
        ((JCTree)((Object)state.getPath().getCompilationUnit())).accept(new TreeScanner(){

            @Override
            public void visitIdent(JCTree.JCIdent tree) {
                if (sym.equals(ASTHelpers.getSymbol((Tree)tree))) {
                    fix.replace((Tree)tree, replacement);
                }
            }

            @Override
            public void visitSelect(JCTree.JCFieldAccess tree) {
                if (sym.equals(ASTHelpers.getSymbol((Tree)tree))) {
                    fix.replace(state.getEndPosition((Tree)tree.getExpression()), state.getEndPosition((Tree)tree), "." + replacement);
                }
                super.visitSelect(tree);
            }
        });
        return fix.build();
    }
}

