/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.File;
import java.io.IOException;

public abstract class WordReader {
    private static final char COMMENT_CHARACTER = '#';
    private File baseDir;
    private WordReader includeWordReader;
    private String currentLine;
    private int currentLineLength;
    private int currentIndex;
    private String currentWord;
    private String currentComments;

    protected WordReader(File file) {
        this.baseDir = file;
    }

    public void setBaseDir(File file) {
        if (this.includeWordReader != null) {
            this.includeWordReader.setBaseDir(file);
        } else {
            this.baseDir = file;
        }
    }

    public File getBaseDir() {
        return this.includeWordReader != null ? this.includeWordReader.getBaseDir() : this.baseDir;
    }

    public void includeWordReader(WordReader wordReader) {
        if (this.includeWordReader == null) {
            this.includeWordReader = wordReader;
        } else {
            this.includeWordReader.includeWordReader(wordReader);
        }
    }

    public String nextWord(boolean bl) throws IOException {
        int n;
        this.currentWord = null;
        if (this.includeWordReader != null) {
            this.currentWord = this.includeWordReader.nextWord(bl);
            if (this.currentWord != null) {
                return this.currentWord;
            }
            this.includeWordReader.close();
            this.includeWordReader = null;
        }
        if (this.currentLine != null) {
            while (this.currentIndex < this.currentLineLength && Character.isWhitespace(this.currentLine.charAt(this.currentIndex))) {
                ++this.currentIndex;
            }
            if (this.currentIndex < this.currentLineLength && this.isComment(this.currentLine.charAt(this.currentIndex))) {
                this.currentIndex = this.currentLineLength;
            }
        }
        while (this.currentLine == null || this.currentIndex == this.currentLineLength) {
            this.currentLine = this.nextLine();
            if (this.currentLine == null) {
                return null;
            }
            this.currentLineLength = this.currentLine.length();
            this.currentIndex = 0;
            while (this.currentIndex < this.currentLineLength && Character.isWhitespace(this.currentLine.charAt(this.currentIndex))) {
                ++this.currentIndex;
            }
            if (this.currentIndex >= this.currentLineLength || !this.isComment(this.currentLine.charAt(this.currentIndex))) continue;
            String string = this.currentLine.substring(this.currentIndex + 1);
            this.currentComments = this.currentComments == null ? string : this.currentComments + '\n' + string;
            this.currentIndex = this.currentLineLength;
        }
        int n2 = this.currentIndex;
        char c = this.currentLine.charAt(n2);
        if (this.isQuote(c)) {
            ++n2;
            do {
                ++this.currentIndex;
                if (this.currentIndex != this.currentLineLength) continue;
                this.currentWord = this.currentLine.substring(n2 - 1, this.currentIndex);
                throw new IOException("Missing closing quote for " + this.locationDescription());
            } while (this.currentLine.charAt(this.currentIndex) != c);
            n = this.currentIndex++;
        } else if (bl && !this.isOption(c)) {
            char c2;
            while (!(this.currentIndex >= this.currentLineLength || this.isFileDelimiter(c2 = this.currentLine.charAt(this.currentIndex)) || (this.isOption(c2) || this.isComment(c2)) && Character.isWhitespace(this.currentLine.charAt(this.currentIndex - 1)))) {
                ++this.currentIndex;
            }
            for (n = this.currentIndex; n > n2 && Character.isWhitespace(this.currentLine.charAt(n - 1)); --n) {
            }
        } else if (this.isDelimiter(c)) {
            n = ++this.currentIndex;
        } else {
            char c3;
            while (!(this.currentIndex >= this.currentLineLength || this.isDelimiter(c3 = this.currentLine.charAt(this.currentIndex)) || Character.isWhitespace(c3) || this.isComment(c3))) {
                ++this.currentIndex;
            }
            n = this.currentIndex;
        }
        this.currentWord = this.currentLine.substring(n2, n);
        return this.currentWord;
    }

    public String lastComments() throws IOException {
        if (this.includeWordReader == null) {
            String string = this.currentComments;
            this.currentComments = null;
            return string;
        }
        return this.includeWordReader.lastComments();
    }

    public String locationDescription() {
        return (this.includeWordReader == null ? (this.currentWord == null ? "end of " : "'" + this.currentWord + "' in ") : this.includeWordReader.locationDescription() + ",\n" + "  included from ") + this.lineLocationDescription();
    }

    protected abstract String nextLine() throws IOException;

    protected abstract String lineLocationDescription();

    public void close() throws IOException {
        if (this.includeWordReader != null) {
            this.includeWordReader.close();
            this.includeWordReader = null;
        }
    }

    private boolean isOption(char c) {
        return c == '-';
    }

    private boolean isComment(char c) {
        return c == '#';
    }

    private boolean isDelimiter(char c) {
        return c == '@' || c == '{' || c == '}' || c == '(' || c == ')' || c == ',' || c == ';' || c == File.pathSeparatorChar;
    }

    private boolean isFileDelimiter(char c) {
        return c == '(' || c == ')' || c == ',' || c == ';' || c == File.pathSeparatorChar;
    }

    private boolean isQuote(char c) {
        return c == '\'' || c == '\"';
    }
}

