/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.dataflow.cfg.node;

import com.sun.source.tree.Tree;
import java.util.ArrayDeque;
import java.util.Collection;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.dataflow.cfg.block.Block;
import org.checkerframework.shaded.dataflow.cfg.node.AssignmentContext;
import org.checkerframework.shaded.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.shaded.dataflow.qual.Pure;

public abstract class Node {
    protected @Nullable Block block;
    protected boolean lvalue = false;
    protected @Nullable AssignmentContext assignmentContext;
    protected boolean inSource = true;
    protected final TypeMirror type;

    public Node(TypeMirror type) {
        assert (type != null);
        this.type = type;
    }

    public @Nullable Block getBlock() {
        return this.block;
    }

    public void setBlock(Block b) {
        this.block = b;
    }

    @Pure
    public abstract @Nullable Tree getTree();

    public TypeMirror getType() {
        return this.type;
    }

    public abstract <R, P> R accept(NodeVisitor<R, P> var1, P var2);

    @Pure
    public boolean isLValue() {
        return this.lvalue;
    }

    public void setLValue() {
        this.lvalue = true;
    }

    public boolean getInSource() {
        return this.inSource;
    }

    public void setInSource(boolean inSrc) {
        this.inSource = inSrc;
    }

    public @Nullable AssignmentContext getAssignmentContext() {
        return this.assignmentContext;
    }

    public void setAssignmentContext(AssignmentContext assignmentContext) {
        this.assignmentContext = assignmentContext;
    }

    public abstract Collection<Node> getOperands();

    public Collection<Node> getTransitiveOperands() {
        ArrayDeque<Node> operands = new ArrayDeque<Node>(this.getOperands());
        ArrayDeque<Node> transitiveOperands = new ArrayDeque<Node>(operands.size());
        while (!operands.isEmpty()) {
            Node next = operands.removeFirst();
            operands.addAll(next.getOperands());
            transitiveOperands.add(next);
        }
        return transitiveOperands;
    }
}

