/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip;

import com.android.builder.internal.packaging.zip.CentralDirectoryHeader;
import com.android.builder.internal.packaging.zip.CompressionMethod;
import com.android.builder.internal.packaging.zip.GPFlags;
import com.android.builder.internal.packaging.zip.StoredEntry;
import com.android.builder.internal.packaging.zip.ZFile;
import com.android.builder.internal.packaging.zip.ZipField;
import com.android.builder.internal.packaging.zip.ZipFieldInvariant;
import com.android.builder.internal.packaging.zip.ZipFieldInvariantNonNegative;
import com.android.builder.internal.packaging.zip.utils.CachedSupplier;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

class CentralDirectory {
    private static final ZipField.F4 F_SIGNATURE = new ZipField.F4(0, 33639248L, "Signature");
    private static final ZipField.F2 F_MADE_BY = new ZipField.F2(F_SIGNATURE.endOffset(), "Made by", new ZipFieldInvariantNonNegative());
    private static final ZipField.F2 F_VERSION_EXTRACT = new ZipField.F2(F_MADE_BY.endOffset(), "Version to extract", new ZipFieldInvariantNonNegative());
    private static final ZipField.F2 F_GP_BIT = new ZipField.F2(F_VERSION_EXTRACT.endOffset(), "GP bit", new ZipFieldInvariant[0]);
    private static final ZipField.F2 F_METHOD = new ZipField.F2(F_GP_BIT.endOffset(), "Method", new ZipFieldInvariant[0]);
    private static final ZipField.F2 F_LAST_MOD_TIME = new ZipField.F2(F_METHOD.endOffset(), "Last modification time", new ZipFieldInvariant[0]);
    private static final ZipField.F2 F_LAST_MOD_DATE = new ZipField.F2(F_LAST_MOD_TIME.endOffset(), "Last modification date", new ZipFieldInvariant[0]);
    private static final ZipField.F4 F_CRC32 = new ZipField.F4(F_LAST_MOD_DATE.endOffset(), "CRC32", new ZipFieldInvariant[0]);
    private static final ZipField.F4 F_COMPRESSED_SIZE = new ZipField.F4(F_CRC32.endOffset(), "Compressed size", new ZipFieldInvariantNonNegative());
    private static final ZipField.F4 F_UNCOMPRESSED_SIZE = new ZipField.F4(F_COMPRESSED_SIZE.endOffset(), "Uncompressed size", new ZipFieldInvariantNonNegative());
    private static final ZipField.F2 F_FILE_NAME_LENGTH = new ZipField.F2(F_UNCOMPRESSED_SIZE.endOffset(), "File name length", new ZipFieldInvariantNonNegative());
    private static final ZipField.F2 F_EXTRA_FIELD_LENGTH = new ZipField.F2(F_FILE_NAME_LENGTH.endOffset(), "Extra field length", new ZipFieldInvariantNonNegative());
    private static final ZipField.F2 F_COMMENT_LENGTH = new ZipField.F2(F_EXTRA_FIELD_LENGTH.endOffset(), "Comment length", new ZipFieldInvariantNonNegative());
    private static final ZipField.F2 F_DISK_NUMBER_START = new ZipField.F2(F_COMMENT_LENGTH.endOffset(), 0L, "Disk start");
    private static final ZipField.F2 F_INTERNAL_ATTRIBUTES = new ZipField.F2(F_DISK_NUMBER_START.endOffset(), "Int attributes", new ZipFieldInvariant[0]);
    private static final ZipField.F4 F_EXTERNAL_ATTRIBUTES = new ZipField.F4(F_INTERNAL_ATTRIBUTES.endOffset(), "Ext attributes", new ZipFieldInvariant[0]);
    private static final ZipField.F4 F_OFFSET = new ZipField.F4(F_EXTERNAL_ATTRIBUTES.endOffset(), "Offset", new ZipFieldInvariantNonNegative());
    private static final int MAX_VERSION_TO_EXTRACT = 20;
    private static final int ASCII_BIT = 1;
    private final Map<String, StoredEntry> mEntries = Maps.newHashMap();
    private final ZFile mFile;
    private final CachedSupplier<byte[]> mBytesSupplier;

    CentralDirectory(ZFile file) {
        this.mFile = file;
        this.mBytesSupplier = new CachedSupplier<byte[]>(){

            @Override
            protected byte[] compute() throws IOException {
                return CentralDirectory.this.computeByteRepresentation();
            }
        };
    }

    static CentralDirectory makeFromData(ByteSource bytes, int count, ZFile file) throws IOException {
        Preconditions.checkNotNull((Object)bytes, (Object)"bytes == null");
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"count < 0");
        long totalRead = 0L;
        CentralDirectory directory = new CentralDirectory(file);
        for (int i = 0; i < count; ++i) {
            try {
                totalRead += directory.readEntry(bytes.slice(totalRead, bytes.size()));
                continue;
            }
            catch (IOException e) {
                throw new IOException("Failed to read directory entry index " + i + " (total " + "directory bytes read: " + totalRead + ").", e);
            }
        }
        if (totalRead != bytes.size()) {
            throw new IOException("Directory has a total of " + bytes.size() + " bytes but after " + "reading all " + count + " entries, only " + totalRead + " bytes were read.");
        }
        return directory;
    }

    static CentralDirectory makeFromEntries(Set<StoredEntry> entries, ZFile file) {
        CentralDirectory directory = new CentralDirectory(file);
        for (StoredEntry entry : entries) {
            CentralDirectoryHeader cdr = entry.getCentralDirectoryHeader();
            Preconditions.checkArgument((!directory.mEntries.containsKey(cdr.getName()) ? 1 : 0) != 0, (Object)"Duplicate filename");
            directory.mEntries.put(cdr.getName(), entry);
        }
        return directory;
    }

    private long readEntry(ByteSource bytes) throws IOException {
        Preconditions.checkNotNull((Object)bytes, (Object)"bytes == null");
        F_SIGNATURE.verify(bytes);
        long madeBy = F_MADE_BY.read(bytes);
        long versionNeededToExtract = F_VERSION_EXTRACT.read(bytes);
        if (versionNeededToExtract > 20L) {
            throw new IOException("Unknown version needed to extract in zip directory entry: " + versionNeededToExtract + ".");
        }
        long gpBit = F_GP_BIT.read(bytes);
        GPFlags flags = GPFlags.from(gpBit);
        long methodCode = F_METHOD.read(bytes);
        CompressionMethod method = CompressionMethod.fromCode(methodCode);
        if (method == null) {
            throw new IOException("Unknown method in zip directory entry: " + methodCode + ".");
        }
        long lastModTime = F_LAST_MOD_TIME.read(bytes);
        long lastModDate = F_LAST_MOD_DATE.read(bytes);
        long crc32 = F_CRC32.read(bytes);
        long compressedSize = F_COMPRESSED_SIZE.read(bytes);
        long uncompressedSize = F_UNCOMPRESSED_SIZE.read(bytes);
        long fileNameLength = F_FILE_NAME_LENGTH.read(bytes);
        long extraFieldLength = F_EXTRA_FIELD_LENGTH.read(bytes);
        long fileCommentLength = F_COMMENT_LENGTH.read(bytes);
        F_DISK_NUMBER_START.verify(bytes);
        long internalAttributes = F_INTERNAL_ATTRIBUTES.read(bytes);
        if ((internalAttributes & 0xFFFFFFFFFFFFFFFEL) != 0L) {
            throw new IOException("Invalid internal attributes: " + internalAttributes + ".");
        }
        long externalAttributes = F_EXTERNAL_ATTRIBUTES.read(bytes);
        long offset = F_OFFSET.read(bytes);
        long expectedSize = (long)F_OFFSET.endOffset() + fileNameLength + extraFieldLength + fileCommentLength;
        if (bytes.size() < expectedSize) {
            throw new IOException("Directory entry should have " + expectedSize + " bytes (name = " + fileNameLength + ", extra = " + extraFieldLength + ", comment = " + fileCommentLength + "), but it has " + bytes.size() + ".");
        }
        ByteSource fileNameBytes = bytes.slice((long)F_OFFSET.endOffset(), fileNameLength);
        String fileName = fileNameBytes.asCharSource(Charsets.US_ASCII).read();
        CentralDirectoryHeader centralDirectoryHeader = new CentralDirectoryHeader(fileName, compressedSize, uncompressedSize, method);
        centralDirectoryHeader.setMadeBy(madeBy);
        centralDirectoryHeader.setVersionExtract(versionNeededToExtract);
        centralDirectoryHeader.setGpBit(flags);
        centralDirectoryHeader.setLastModTime(lastModTime);
        centralDirectoryHeader.setLastModDate(lastModDate);
        centralDirectoryHeader.setCrc32(crc32);
        centralDirectoryHeader.setInternalAttributes(internalAttributes);
        centralDirectoryHeader.setExternalAttributes(externalAttributes);
        centralDirectoryHeader.setOffset(offset);
        centralDirectoryHeader.setExtraField(bytes.slice((long)F_OFFSET.endOffset() + fileNameLength, extraFieldLength).read());
        centralDirectoryHeader.setComment(bytes.slice((long)F_OFFSET.endOffset() + fileNameLength + extraFieldLength, fileCommentLength).read());
        StoredEntry entry = new StoredEntry(centralDirectoryHeader, this.mFile);
        if (this.mEntries.containsKey(fileName)) {
            throw new IOException("File file contains duplicate file '" + fileName + "'.");
        }
        this.mEntries.put(fileName, entry);
        return expectedSize;
    }

    Map<String, StoredEntry> getEntries() {
        return ImmutableMap.copyOf(this.mEntries);
    }

    byte[] toBytes() throws IOException {
        return this.mBytesSupplier.get();
    }

    private byte[] computeByteRepresentation() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        for (StoredEntry entry : this.mEntries.values()) {
            CentralDirectoryHeader cdr = entry.getCentralDirectoryHeader();
            F_SIGNATURE.write(bytesOut);
            F_MADE_BY.write(bytesOut, cdr.getMadeBy());
            F_VERSION_EXTRACT.write(bytesOut, cdr.getVersionExtract());
            F_GP_BIT.write(bytesOut, cdr.getGpBit().getValue());
            F_METHOD.write(bytesOut, cdr.getMethod().methodCode);
            F_LAST_MOD_TIME.write(bytesOut, cdr.getLastModTime());
            F_LAST_MOD_DATE.write(bytesOut, cdr.getLastModDate());
            F_CRC32.write(bytesOut, cdr.getCrc32());
            F_COMPRESSED_SIZE.write(bytesOut, cdr.getCompressedSize());
            F_UNCOMPRESSED_SIZE.write(bytesOut, cdr.getUncompressedSize());
            F_FILE_NAME_LENGTH.write(bytesOut, cdr.getName().length());
            F_EXTRA_FIELD_LENGTH.write(bytesOut, cdr.getExtraField().length);
            F_COMMENT_LENGTH.write(bytesOut, cdr.getComment().length);
            F_DISK_NUMBER_START.write(bytesOut);
            F_INTERNAL_ATTRIBUTES.write(bytesOut, cdr.getInternalAttributes());
            F_EXTERNAL_ATTRIBUTES.write(bytesOut, cdr.getExternalAttributes());
            F_OFFSET.write(bytesOut, cdr.getOffset());
            bytesOut.write(cdr.getName().getBytes(Charsets.US_ASCII));
            bytesOut.write(cdr.getExtraField());
            bytesOut.write(cdr.getComment());
        }
        return bytesOut.toByteArray();
    }
}

