/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(name="JUnit4ClassUsedInJUnit3", summary="Some JUnit4 construct cannot be used in a JUnit3 context. Convert your class to JUnit4 style to use them.", category=BugPattern.Category.JUNIT, severity=BugPattern.SeverityLevel.WARNING)
public class JUnit4ClassUsedInJUnit3
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.AnnotationTreeMatcher {
    private static final Matcher<ExpressionTree> ASSUME_CHECK = Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.staticMethod().onClass("org.junit.Assume").withAnyName(), Matchers.enclosingClass((Matcher)JUnitMatchers.isJUnit3TestClass)});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!ASSUME_CHECK.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.makeDescription("Assume", tree);
    }

    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        if (!Matchers.enclosingClass((Matcher)JUnitMatchers.isJUnit3TestClass).matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (Matchers.isType((String)"org.junit.Ignore").matches((Tree)tree, state)) {
            return this.makeDescription("@Ignore", tree);
        }
        if (Matchers.isType((String)"org.junit.Rule").matches((Tree)tree, state)) {
            return this.makeDescription("@Rule", tree);
        }
        return Description.NO_MATCH;
    }

    private Description makeDescription(String rejectedJUnit4, Tree tree) {
        Description.Builder builder = this.buildDescription(tree).setMessage(String.format("%s cannot be used inside a JUnit3 class. Convert your class to JUnit4 style.", rejectedJUnit4));
        return builder.build();
    }
}

