/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.deps;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.turbine.binder.Binder;
import com.google.turbine.binder.ClassPath;
import com.google.turbine.binder.bound.EnumConstantValue;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.bound.TurbineAnnotationValue;
import com.google.turbine.binder.bound.TurbineClassValue;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.bytecode.BytecodeBoundClass;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.SimpleEnv;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.lower.Lower;
import com.google.turbine.model.Const;
import com.google.turbine.proto.DepsProto;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import java.io.BufferedInputStream;
import java.io.IOError;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;

public class Dependencies {
    public static DepsProto.Dependencies collectDeps(Optional<String> targetLabel, ClassPath bootclasspath, Binder.BindingResult bound, Lower.Lowered lowered) {
        DepsProto.Dependencies.Builder deps = DepsProto.Dependencies.newBuilder();
        Set<ClassSymbol> closure = Dependencies.superTypeClosure(bound, lowered);
        Dependencies.addPackageInfos(closure, bound);
        LinkedHashSet<String> jars = new LinkedHashSet<String>();
        for (ClassSymbol sym : closure) {
            BytecodeBoundClass info = bound.classPathEnv().get(sym);
            if (info == null) continue;
            String jarFile = info.jarFile();
            if (bootclasspath.env().get(sym) != null) continue;
            jars.add(jarFile);
        }
        for (String jarFile : jars) {
            deps.addDependency(DepsProto.Dependency.newBuilder().setPath(jarFile).setKind(DepsProto.Dependency.Kind.EXPLICIT));
        }
        deps.setSuccess(true);
        if (targetLabel.isPresent()) {
            deps.setRuleLabel(targetLabel.get());
        }
        return deps.build();
    }

    private static Set<ClassSymbol> superTypeClosure(Binder.BindingResult bound, Lower.Lowered lowered) {
        CompoundEnv<ClassSymbol, TypeBoundClass> env = CompoundEnv.of(new SimpleEnv<ClassSymbol, SourceTypeBoundClass>(bound.units())).append(bound.classPathEnv());
        LinkedHashSet<ClassSymbol> closure = new LinkedHashSet<ClassSymbol>((Collection<ClassSymbol>)lowered.symbols());
        for (ClassSymbol sym : lowered.symbols()) {
            TypeBoundClass info = (TypeBoundClass)env.get(sym);
            Dependencies.addAnnotations(closure, info.annotations());
            for (TypeBoundClass.MethodInfo method : info.methods()) {
                Dependencies.addAnnotations(closure, method.annotations());
            }
            for (TypeBoundClass.FieldInfo field : info.fields()) {
                Dependencies.addAnnotations(closure, field.annotations());
            }
            Dependencies.addSuperTypes(closure, env, info);
        }
        return closure;
    }

    private static void addAnnotations(Set<ClassSymbol> closure, ImmutableList<AnnoInfo> annotations) {
        for (AnnoInfo annoInfo : annotations) {
            Dependencies.addAnnotation(closure, annoInfo);
        }
    }

    private static void addAnnotation(Set<ClassSymbol> closure, AnnoInfo annoInfo) {
        closure.add(annoInfo.sym());
        for (Const c : annoInfo.values().values()) {
            Dependencies.addConst(closure, c);
        }
    }

    private static void addConst(Set<ClassSymbol> closure, Const c) {
        switch (c.kind()) {
            case ARRAY: {
                for (Const e : ((Const.ArrayInitValue)c).elements()) {
                    Dependencies.addConst(closure, e);
                }
                break;
            }
            case CLASS_LITERAL: {
                Type t = ((TurbineClassValue)c).type();
                if (t.tyKind() != Type.TyKind.CLASS_TY) break;
                closure.add(((Type.ClassTy)t).sym());
                break;
            }
            case ENUM_CONSTANT: {
                closure.add(((EnumConstantValue)c).sym().owner());
                break;
            }
            case ANNOTATION: {
                Dependencies.addAnnotation(closure, ((TurbineAnnotationValue)c).info());
                break;
            }
        }
    }

    private static void addSuperTypes(Set<ClassSymbol> closure, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym) {
        if (!closure.add(sym)) {
            return;
        }
        TypeBoundClass info = env.get(sym);
        if (info == null) {
            return;
        }
        Dependencies.addSuperTypes(closure, env, info);
    }

    private static void addSuperTypes(Set<ClassSymbol> closure, Env<ClassSymbol, TypeBoundClass> env, TypeBoundClass info) {
        if (info.superclass() != null) {
            Dependencies.addSuperTypes(closure, env, info.superclass());
        }
        for (ClassSymbol i : info.interfaces()) {
            Dependencies.addSuperTypes(closure, env, i);
        }
    }

    private static void addPackageInfos(Set<ClassSymbol> closure, Binder.BindingResult bound) {
        LinkedHashSet<ClassSymbol> packages = new LinkedHashSet<ClassSymbol>();
        for (ClassSymbol sym : closure) {
            String packageName = sym.packageName();
            if (packageName.isEmpty()) continue;
            packages.add(new ClassSymbol(packageName + "/package-info"));
        }
        for (ClassSymbol pkg : packages) {
            if (bound.classPathEnv().get(pkg) == null) continue;
            closure.add(pkg);
        }
    }

    public static Collection<String> reduceClasspath(ImmutableList<String> transitiveClasspath, ImmutableSet<String> directJars, ImmutableList<String> depsArtifacts) {
        if (directJars.isEmpty()) {
            return transitiveClasspath;
        }
        HashSet<String> reduced = new HashSet<String>((Collection<String>)directJars);
        for (String path : depsArtifacts) {
            DepsProto.Dependencies.Builder deps = DepsProto.Dependencies.newBuilder();
            try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]));){
                deps.mergeFrom(is);
            }
            catch (IOException e) {
                throw new IOError(e);
            }
            for (DepsProto.Dependency dep : deps.build().getDependencyList()) {
                switch (dep.getKind()) {
                    case EXPLICIT: 
                    case IMPLICIT: {
                        reduced.add(dep.getPath());
                        break;
                    }
                }
            }
        }
        return Collections2.filter(transitiveClasspath, (Predicate)Predicates.in(reduced));
    }
}

