/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import java.io.PrintStream;
import java.util.List;
import proguard.util.ClassNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public class WarningPrinter {
    private final PrintStream printStream;
    private final StringMatcher classFilter;
    private int warningCount;

    public WarningPrinter() {
        this(System.err);
    }

    public WarningPrinter(PrintStream printStream) {
        this.printStream = printStream;
        this.classFilter = null;
    }

    public WarningPrinter(PrintStream printStream, List list) {
        this.printStream = printStream;
        this.classFilter = list == null ? null : new ListParser(new ClassNameParser()).parse(list);
    }

    public void print(String string, String string2) {
        if (this.accepts(string)) {
            this.print(string2);
        }
    }

    public boolean accepts(String string) {
        return this.classFilter == null || !this.classFilter.matches(string);
    }

    public void print(String string, String string2, String string3) {
        if (this.accepts(string, string2)) {
            this.print(string3);
        }
    }

    public boolean accepts(String string, String string2) {
        return this.classFilter == null || !this.classFilter.matches(string) && !this.classFilter.matches(string2);
    }

    private void print(String string) {
        this.printStream.println(string);
        ++this.warningCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }
}

