/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import java.util.List;
import java.util.regex.Pattern;

@BugPattern(name="UndefinedEquals", summary="Collection, Iterable, Multimap, and Queue do not have well-defined equals behavior", severity=BugPattern.SeverityLevel.WARNING)
public final class UndefinedEquals
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final ImmutableList<String> BAD_CLASS_LIST = ImmutableList.of((Object)"com.google.common.collect.Multimap", (Object)"java.lang.Iterable", (Object)"java.util.Collection", (Object)"java.util.Queue");
    private static final Matcher<MethodInvocationTree> ASSERT_THAT_EQUALS = Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.Subject").withNameMatching(Pattern.compile("is(Not)?EqualTo")), Matchers.receiverOfInvocation((Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("com.google.common.truth.Truth").named("assertThat"), MethodMatchers.instanceMethod().onDescendantOf("com.google.common.truth.StandardSubjectBuilder").named("that")}))});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Type argumentType;
        Type receiverType;
        List<? extends ExpressionTree> arguments = tree.getArguments();
        if (Matchers.staticEqualsInvocation().matches((Tree)tree, state) || Matchers.assertEqualsInvocation().matches((Tree)tree, state) || Matchers.assertNotEqualsInvocation().matches((Tree)tree, state)) {
            receiverType = ASTHelpers.getType((Tree)arguments.get(arguments.size() - 2));
            argumentType = ASTHelpers.getType((Tree)((Tree)Iterables.getLast(arguments)));
        } else if (Matchers.instanceEqualsInvocation().matches((Tree)tree, state)) {
            receiverType = ASTHelpers.getReceiverType((ExpressionTree)tree);
            argumentType = ASTHelpers.getType((Tree)arguments.get(0));
        } else if (ASSERT_THAT_EQUALS.matches((Tree)tree, state)) {
            receiverType = ASTHelpers.getType((Tree)((Tree)Iterables.getOnlyElement(arguments)));
            argumentType = ASTHelpers.getType((Tree)((Tree)Iterables.getOnlyElement(((MethodInvocationTree)ASTHelpers.getReceiver((ExpressionTree)tree)).getArguments())));
        } else {
            return Description.NO_MATCH;
        }
        return BAD_CLASS_LIST.stream().filter(t -> ASTHelpers.isSameType((Type)receiverType, (Type)state.getTypeFromString(t), (VisitorState)state) || ASTHelpers.isSameType((Type)argumentType, (Type)state.getTypeFromString(t), (VisitorState)state)).findFirst().map(b -> this.buildDescription(tree).setMessage(b + " does not have well-defined equals behavior").build()).orElse(Description.NO_MATCH);
    }
}

