/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.PathFileObject;
import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.tools.FileObject;

public class JRTIndex {
    private static JRTIndex sharedInstance;
    private final FileSystem jrtfs = FileSystems.getFileSystem(URI.create("jrt:/"));
    private final Map<RelativePath.RelativeDirectory, SoftReference<Entry>> entries = new HashMap<RelativePath.RelativeDirectory, SoftReference<Entry>>();
    private ResourceBundle ctBundle;

    public static synchronized JRTIndex getSharedInstance() {
        if (sharedInstance == null) {
            try {
                sharedInstance = new JRTIndex();
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }
        return sharedInstance;
    }

    public static JRTIndex instance(Context context) {
        try {
            JRTIndex jRTIndex = context.get(JRTIndex.class);
            if (jRTIndex == null) {
                jRTIndex = new JRTIndex();
                context.put(JRTIndex.class, jRTIndex);
            }
            return jRTIndex;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public static boolean isAvailable() {
        try {
            FileSystems.getFileSystem(URI.create("jrt:/"));
            return true;
        }
        catch (FileSystemNotFoundException | ProviderNotFoundException runtimeException) {
            return false;
        }
    }

    private JRTIndex() throws IOException {
    }

    public CtSym getCtSym(CharSequence charSequence) throws IOException {
        return this.getEntry((RelativePath.RelativeDirectory)RelativePath.RelativeDirectory.forPackage((CharSequence)charSequence)).ctSym;
    }

    synchronized Entry getEntry(RelativePath.RelativeDirectory relativeDirectory) throws IOException {
        Entry entry;
        SoftReference<Entry> softReference = this.entries.get(relativeDirectory);
        Entry entry2 = entry = softReference == null ? null : softReference.get();
        if (entry == null) {
            Iterable<Path> iterable;
            Path path;
            LinkedHashMap<String, Path> linkedHashMap = new LinkedHashMap<String, Path>();
            LinkedHashSet<RelativePath.RelativeDirectory> linkedHashSet = new LinkedHashSet<RelativePath.RelativeDirectory>();
            if (relativeDirectory.path.isEmpty()) {
                path = this.jrtfs.getPath("/modules", new String[0]);
            } else {
                iterable = this.jrtfs.getPath("/packages", new String[0]);
                path = iterable.resolve(relativeDirectory.getPath().replaceAll("/$", "").replace("/", "."));
            }
            if (Files.exists(path, new LinkOption[0])) {
                iterable = Files.newDirectoryStream(path);
                Throwable throwable = null;
                try {
                    for (Path path2 : iterable) {
                        Path path3;
                        if (Files.isSymbolicLink(path2)) {
                            path2 = Files.readSymbolicLink(path2);
                        }
                        if (!Files.exists(path3 = relativeDirectory.resolveAgainst(path2), new LinkOption[0])) continue;
                        DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path3);
                        Throwable throwable2 = null;
                        try {
                            for (Path path4 : directoryStream) {
                                String string = path4.getFileName().toString();
                                if (Files.isRegularFile(path4, new LinkOption[0])) {
                                    linkedHashMap.put(string, path4);
                                    continue;
                                }
                                if (!Files.isDirectory(path4, new LinkOption[0])) continue;
                                linkedHashSet.add(new RelativePath.RelativeDirectory(relativeDirectory, string));
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (directoryStream == null) continue;
                            if (throwable2 != null) {
                                try {
                                    directoryStream.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            directoryStream.close();
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (iterable != null) {
                        if (throwable != null) {
                            try {
                                iterable.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            iterable.close();
                        }
                    }
                }
            }
            entry = new Entry(Collections.unmodifiableMap(linkedHashMap), Collections.unmodifiableSet(linkedHashSet), this.getCtInfo(relativeDirectory));
            this.entries.put(relativeDirectory, new SoftReference<Entry>(entry));
        }
        return entry;
    }

    public boolean isInJRT(FileObject fileObject) {
        if (fileObject instanceof PathFileObject) {
            Path path = ((PathFileObject)fileObject).getPath();
            return path.getFileSystem() == this.jrtfs;
        }
        return false;
    }

    private CtSym getCtInfo(RelativePath.RelativeDirectory relativeDirectory) {
        if (relativeDirectory.path.isEmpty()) {
            return CtSym.EMPTY;
        }
        if (this.ctBundle == null) {
            this.ctBundle = ResourceBundle.getBundle("com.sun.tools.javac.resources.ct");
        }
        try {
            String string = this.ctBundle.getString(relativeDirectory.path.replace('/', '.') + '*');
            boolean bl = false;
            boolean bl2 = false;
            String string2 = null;
            String[] stringArray = string.split(" +", 0);
            int n = stringArray.length;
            block10: for (int i = 0; i < n; ++i) {
                String string3;
                switch (string3 = stringArray[i]) {
                    case "hidden": {
                        bl = true;
                        continue block10;
                    }
                    case "proprietary": {
                        bl2 = true;
                        continue block10;
                    }
                    default: {
                        string2 = string3;
                    }
                }
            }
            return new CtSym(bl, bl2, string2);
        }
        catch (MissingResourceException missingResourceException) {
            return CtSym.EMPTY;
        }
    }

    public static class CtSym {
        public final boolean hidden;
        public final boolean proprietary;
        public final String minProfile;
        static final CtSym EMPTY = new CtSym(false, false, null);

        CtSym(boolean bl, boolean bl2, String string) {
            this.hidden = bl;
            this.proprietary = bl2;
            this.minProfile = string;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("CtSym[");
            boolean bl = false;
            if (this.hidden) {
                stringBuilder.append("hidden");
                bl = true;
            }
            if (this.proprietary) {
                if (bl) {
                    stringBuilder.append(",");
                }
                stringBuilder.append("proprietary");
                bl = true;
            }
            if (this.minProfile != null) {
                if (bl) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(this.minProfile);
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    class Entry {
        final Map<String, Path> files;
        final Set<RelativePath.RelativeDirectory> subdirs;
        final CtSym ctSym;

        private Entry(Map<String, Path> map, Set<RelativePath.RelativeDirectory> set, CtSym ctSym) {
            this.files = map;
            this.subdirs = set;
            this.ctSym = ctSym;
        }
    }
}

