/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.javadoc;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.javadoc.Utils;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.doctree.InheritDocTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;

@BugPattern(name="InheritDoc", summary="Invalid use of @inheritDoc.", severity=BugPattern.SeverityLevel.WARNING, tags={"Style"}, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION, documentSuppression=false)
public final class InheritDoc
extends BugChecker
implements BugChecker.ClassTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.VariableTreeMatcher {
    public Description matchClass(ClassTree classTree, VisitorState state) {
        return this.handle(state);
    }

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        return this.handle(state);
    }

    public Description matchVariable(VariableTree variableTree, VisitorState state) {
        return this.handle(state);
    }

    private Description handle(VisitorState state) {
        DocTreePath path = Utils.getDocTreePath(state);
        if (path != null) {
            new InheritDocChecker(state).scan(path, null);
        }
        return Description.NO_MATCH;
    }

    private final class InheritDocChecker
    extends DocTreePathScanner<Void, Void> {
        private final VisitorState state;

        private InheritDocChecker(VisitorState state) {
            this.state = state;
        }

        @Override
        public Void visitInheritDoc(InheritDocTree inheritDocTree, Void unused) {
            new SimpleTreeVisitor<Void, Void>(){

                @Override
                public Void visitVariable(VariableTree variableTree, Void unused) {
                    InheritDocChecker.this.state.reportMatch(InheritDoc.this.buildDescription(Utils.diagnosticPosition(InheritDocChecker.this.getCurrentPath(), InheritDocChecker.this.state)).setMessage("@inheritDoc doesn't make sense on variables as they cannot override a super element.").build());
                    return null;
                }

                @Override
                public Void visitMethod(MethodTree methodTree, Void unused) {
                    Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)methodTree);
                    if (methodSymbol != null && ASTHelpers.findSuperMethods((Symbol.MethodSymbol)methodSymbol, (Types)InheritDocChecker.this.state.getTypes()).isEmpty()) {
                        InheritDocChecker.this.state.reportMatch(InheritDoc.this.buildDescription(Utils.diagnosticPosition(InheritDocChecker.this.getCurrentPath(), InheritDocChecker.this.state)).setMessage("This method does not override anything to inherit documentation from.").build());
                    }
                    return null;
                }

                @Override
                public Void visitClass(ClassTree classTree, Void unused) {
                    if (classTree.getExtendsClause() == null && classTree.getImplementsClause().isEmpty()) {
                        InheritDocChecker.this.state.reportMatch(InheritDoc.this.buildDescription(Utils.diagnosticPosition(InheritDocChecker.this.getCurrentPath(), InheritDocChecker.this.state)).setMessage("This class does not extend or implement anything to inherit documentation from.").build());
                    }
                    return null;
                }
            }.visit(this.getCurrentPath().getTreePath().getLeaf(), null);
            return (Void)super.visitInheritDoc(inheritDocTree, null);
        }
    }
}

