/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import javax.lang.model.element.Modifier;

@BugPattern(name="DoNotCall", summary="This method should not be called.", severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class DoNotCallChecker
extends BugChecker
implements BugChecker.MethodTreeMatcher,
BugChecker.MethodInvocationTreeMatcher,
BugChecker.MemberReferenceTreeMatcher {
    private static final String DO_NOT_CALL = "com.google.errorprone.annotations.DoNotCall";

    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MethodTree)tree);
        if (symbol == null) {
            return Description.NO_MATCH;
        }
        if (ASTHelpers.hasAnnotation((Tree)tree, (String)DO_NOT_CALL, (VisitorState)state)) {
            if (symbol.getModifiers().contains((Object)Modifier.PRIVATE)) {
                return this.buildDescription(tree).setMessage("A private method that should not be called should simply be removed.").build();
            }
            if (symbol.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                return Description.NO_MATCH;
            }
            if (symbol.getModifiers().contains((Object)Modifier.FINAL)) {
                return Description.NO_MATCH;
            }
            if (symbol.owner.enclClass().getModifiers().contains((Object)Modifier.FINAL)) {
                return Description.NO_MATCH;
            }
            return this.buildDescription(tree).setMessage("Methods annotated with @DoNotCall should be final.").addFix(SuggestedFixes.addModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL})).build();
        }
        return ASTHelpers.findSuperMethods((Symbol.MethodSymbol)symbol, (Types)state.getTypes()).stream().filter(s -> ASTHelpers.hasAnnotation((Symbol)s, (String)DO_NOT_CALL, (VisitorState)state)).findAny().map(s -> {
            String message = String.format("Method overrides %s in %s which is annotated @DoNotCall, it should also be annotated.", s.getSimpleName(), s.owner.getSimpleName());
            return this.buildDescription(tree).setMessage(message).addFix((Fix)SuggestedFix.builder().addImport(DO_NOT_CALL).prefixWith((Tree)tree, "@DoNotCall ").build()).build();
        }).orElse(Description.NO_MATCH);
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return this.checkTree(tree, ASTHelpers.getSymbol((MethodInvocationTree)tree), state);
    }

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        return this.checkTree(tree, ASTHelpers.getSymbol((MemberReferenceTree)tree), state);
    }

    private Description checkTree(Tree tree, Symbol.MethodSymbol sym, VisitorState state) {
        if (!ASTHelpers.hasAnnotation((Symbol)sym, (String)DO_NOT_CALL, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        String doNotCall = DoNotCallChecker.getDoNotCallValue(sym);
        StringBuilder message = new StringBuilder("This method should not be called");
        if (doNotCall.isEmpty()) {
            message.append(", see its documentation for details.");
        } else {
            message.append(": ").append(doNotCall);
        }
        return this.buildDescription(tree).setMessage(message.toString()).build();
    }

    private static String getDoNotCallValue(Symbol symbol) {
        for (Attribute.Compound a : symbol.getRawAttributes()) {
            if (!a.type.tsym.getQualifiedName().contentEquals(DO_NOT_CALL)) continue;
            return MoreAnnotations.getValue((Attribute.Compound)a, (String)"value").flatMap(MoreAnnotations::asStringValue).orElse("");
        }
        throw new IllegalStateException();
    }
}

