/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.fixes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.io.CharStreams;
import com.google.errorprone.VisitorState;
import com.google.errorprone.apply.DescriptionBasedDiff;
import com.google.errorprone.apply.ImportOrganizer;
import com.google.errorprone.apply.SourceFile;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.google.errorprone.util.FindIdentifiers;
import com.sun.source.doctree.DocTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.main.Arguments;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.net.JarURLConnection;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class SuggestedFixes {
    private static final ImmutableSet<Tree.Kind> TREE_TYPE_UNKNOWN_ANNOTATION = ImmutableSet.of((Object)((Object)Tree.Kind.CLASS), (Object)((Object)Tree.Kind.ENUM), (Object)((Object)Tree.Kind.INTERFACE), (Object)((Object)Tree.Kind.ANNOTATION_TYPE), (Object)((Object)Tree.Kind.METHOD));

    @Nullable
    private static Modifier getTokModifierKind(ErrorProneToken tok) {
        switch (tok.kind()) {
            case PUBLIC: {
                return Modifier.PUBLIC;
            }
            case PROTECTED: {
                return Modifier.PROTECTED;
            }
            case PRIVATE: {
                return Modifier.PRIVATE;
            }
            case ABSTRACT: {
                return Modifier.ABSTRACT;
            }
            case STATIC: {
                return Modifier.STATIC;
            }
            case FINAL: {
                return Modifier.FINAL;
            }
            case TRANSIENT: {
                return Modifier.TRANSIENT;
            }
            case VOLATILE: {
                return Modifier.VOLATILE;
            }
            case SYNCHRONIZED: {
                return Modifier.SYNCHRONIZED;
            }
            case NATIVE: {
                return Modifier.NATIVE;
            }
            case STRICTFP: {
                return Modifier.STRICTFP;
            }
            case DEFAULT: {
                return Modifier.DEFAULT;
            }
        }
        return null;
    }

    public static Optional<SuggestedFix> addModifiers(Tree tree, VisitorState state, Modifier ... modifiers) {
        ModifiersTree originalModifiers = ASTHelpers.getModifiers(tree);
        if (originalModifiers == null) {
            return Optional.empty();
        }
        Sets.SetView toAdd = Sets.difference(new TreeSet<Modifier>(Arrays.asList(modifiers)), originalModifiers.getFlags());
        SuggestedFix.Builder fix = SuggestedFix.builder();
        ArrayList<Modifier> modifiersToWrite = new ArrayList<Modifier>();
        if (!originalModifiers.getFlags().isEmpty()) {
            TreeMap<Modifier, Integer> modifierPositions = new TreeMap<Modifier, Integer>();
            for (Modifier mod : toAdd) {
                modifierPositions.put(mod, -1);
            }
            java.util.List<ErrorProneToken> tokens = state.getTokensForNode(originalModifiers);
            int base = ((JCTree)((Object)originalModifiers)).getStartPosition();
            for (ErrorProneToken tok : tokens) {
                Modifier mod = SuggestedFixes.getTokModifierKind(tok);
                if (mod == null) continue;
                modifierPositions.put(mod, base + tok.pos());
            }
            for (Modifier mod : modifierPositions.keySet()) {
                int p = (Integer)modifierPositions.get((Object)mod);
                if (p == -1) {
                    modifiersToWrite.add(mod);
                    continue;
                }
                if (modifiersToWrite.isEmpty()) continue;
                fix.replace(p, p, Joiner.on((char)' ').join(modifiersToWrite) + " ");
                modifiersToWrite.clear();
            }
        } else {
            modifiersToWrite.addAll((Collection<Modifier>)toAdd);
        }
        SuggestedFixes.addRemainingModifiers(tree, state, originalModifiers, modifiersToWrite, fix);
        return Optional.of(fix.build());
    }

    private static void addRemainingModifiers(Tree tree, VisitorState state, ModifiersTree originalModifiers, Collection<Modifier> toAdd, SuggestedFix.Builder fix) {
        if (toAdd.isEmpty()) {
            return;
        }
        int pos = state.getEndPosition(originalModifiers) != -1 ? state.getEndPosition(originalModifiers) + 1 : ((JCTree)tree).getStartPosition();
        int base = ((JCTree)tree).getStartPosition();
        Optional<Integer> insert = state.getTokensForNode(tree).stream().map(token -> token.pos() + base).filter(thisPos -> thisPos >= pos).findFirst();
        int insertPos = insert.orElse(pos);
        fix.replace(insertPos, insertPos, Joiner.on((char)' ').join(toAdd) + " ");
    }

    public static Optional<SuggestedFix> removeModifiers(Tree tree, VisitorState state, Modifier ... modifiers) {
        ImmutableSet toRemove = ImmutableSet.copyOf((Object[])modifiers);
        ModifiersTree originalModifiers = ASTHelpers.getModifiers(tree);
        if (originalModifiers == null) {
            return Optional.empty();
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        java.util.List<ErrorProneToken> tokens = state.getTokensForNode(originalModifiers);
        int basePos = ((JCTree)((Object)originalModifiers)).getStartPosition();
        boolean empty = true;
        for (ErrorProneToken tok : tokens) {
            Modifier mod = SuggestedFixes.getTokModifierKind(tok);
            if (!toRemove.contains((Object)mod)) continue;
            empty = false;
            fix.replace(basePos + tok.pos(), basePos + tok.endPos() + 1, "");
        }
        if (empty) {
            return Optional.empty();
        }
        return Optional.of(fix.build());
    }

    public static String qualifyType(VisitorState state, SuggestedFix.Builder fix, Symbol sym) {
        if (sym.getKind() == ElementKind.TYPE_PARAMETER) {
            return sym.getSimpleName().toString();
        }
        ArrayDeque<String> names = new ArrayDeque<String>();
        Symbol curr = sym;
        while (curr != null) {
            names.addFirst(curr.getSimpleName().toString());
            Symbol found = FindIdentifiers.findIdent(curr.getSimpleName().toString(), state, Kinds.KindSelector.VAL_TYP);
            if (found == curr) break;
            if (curr.owner != null && curr.owner.getKind() == ElementKind.PACKAGE) {
                if (found != null) {
                    names.addFirst(curr.owner.getQualifiedName().toString());
                    break;
                }
                fix.addImport(curr.getQualifiedName().toString());
                break;
            }
            curr = curr.owner;
        }
        return Joiner.on((char)'.').join(names);
    }

    public static String qualifyType(final VisitorState state, SuggestedFix.Builder fix, TypeMirror type) {
        return type.accept(new SimpleTypeVisitor8<String, SuggestedFix.Builder>(){

            @Override
            protected String defaultAction(TypeMirror e, SuggestedFix.Builder builder) {
                return e.toString();
            }

            @Override
            public String visitArray(ArrayType t, SuggestedFix.Builder builder) {
                return t.getComponentType().accept(this, builder) + "[]";
            }

            @Override
            public String visitDeclared(DeclaredType t, SuggestedFix.Builder builder) {
                String baseType = SuggestedFixes.qualifyType(state, builder, ((Type)((Object)t)).tsym);
                if (t.getTypeArguments().isEmpty()) {
                    return baseType;
                }
                StringBuilder b = new StringBuilder(baseType);
                b.append('<');
                boolean started = false;
                for (TypeMirror typeMirror : t.getTypeArguments()) {
                    if (started) {
                        b.append(',');
                    }
                    b.append(typeMirror.accept(this, builder));
                    started = true;
                }
                b.append('>');
                return b.toString();
            }
        }, fix);
    }

    public static String qualifyType(VisitorState state, SuggestedFix.Builder fix, String typeName) {
        int startOfClass = typeName.indexOf(46);
        while (startOfClass > 0) {
            int endOfClass = typeName.indexOf(46, startOfClass + 1);
            if (endOfClass < 0) {
                endOfClass = typeName.length();
            }
            if (Character.isUpperCase(typeName.charAt(startOfClass + 1))) {
                String className = typeName.substring(startOfClass + 1);
                Symbol found = FindIdentifiers.findIdent(className, state, Kinds.KindSelector.VAL_TYP);
                if (found == null) {
                    fix.addImport(typeName.substring(0, endOfClass));
                    return className;
                }
                if (found.getQualifiedName().contentEquals(typeName)) {
                    return className;
                }
            }
            startOfClass = typeName.indexOf(46, startOfClass + 1);
        }
        return typeName;
    }

    public static void replaceDocTree(SuggestedFix.Builder fix, DocTreePath docPath, String replacement) {
        DocTree leaf = docPath.getLeaf();
        Preconditions.checkArgument((boolean)(leaf instanceof DCTree.DCEndPosTree), (String)"no end position information for %s", (Object)((Object)leaf.getKind()));
        DCTree.DCEndPosTree node = (DCTree.DCEndPosTree)leaf;
        DCTree.DCDocComment comment = (DCTree.DCDocComment)docPath.getDocComment();
        fix.replace((int)node.getSourcePosition(comment), node.getEndPos(comment), replacement);
    }

    public static void qualifyDocReference(SuggestedFix.Builder fix, DocTreePath docPath, VisitorState state) {
        DocTree leaf = docPath.getLeaf();
        Preconditions.checkArgument((leaf.getKind() == DocTree.Kind.REFERENCE ? 1 : 0) != 0, (String)"expected a path to a reference, got %s instead", (Object)((Object)leaf.getKind()));
        DCTree.DCReference reference = (DCTree.DCReference)leaf;
        Symbol sym = (Symbol)JavacTrees.instance(state.context).getElement(docPath);
        if (sym == null) {
            return;
        }
        String refString = reference.toString();
        int idx = refString.indexOf(35);
        String qualifiedName = idx >= 0 ? sym.owner.getQualifiedName() + refString.substring(idx, refString.length()) : sym.getQualifiedName().toString();
        SuggestedFixes.replaceDocTree(fix, docPath, qualifiedName);
    }

    public static Fix addMembers(ClassTree classTree, VisitorState state, String firstMember, String ... otherMembers) {
        Preconditions.checkNotNull((Object)classTree);
        int classEndPosition = state.getEndPosition(classTree);
        StringBuilder stringBuilder = new StringBuilder();
        for (String memberSnippet : Lists.asList((Object)firstMember, (Object[])otherMembers)) {
            stringBuilder.append("\n\n").append(memberSnippet);
        }
        stringBuilder.append('\n');
        return SuggestedFix.replace(classEndPosition - 1, classEndPosition - 1, stringBuilder.toString());
    }

    public static SuggestedFix renameVariable(VariableTree tree, final String replacement, VisitorState state) {
        String name = tree.getName().toString();
        int typeEndPos = state.getEndPosition(tree.getType());
        int searchOffset = typeEndPos == -1 ? 0 : typeEndPos - ((JCTree)((Object)tree)).getStartPosition();
        int pos = ((JCTree)((Object)tree)).getStartPosition() + state.getSourceForNode(tree).indexOf(name, searchOffset);
        final SuggestedFix.Builder fix = SuggestedFix.builder().replace(pos, pos + name.length(), replacement);
        final Symbol.VarSymbol sym = ASTHelpers.getSymbol(tree);
        ((JCTree)((Object)state.getPath().getCompilationUnit())).accept(new TreeScanner(){

            @Override
            public void visitIdent(JCTree.JCIdent tree) {
                if (sym.equals(ASTHelpers.getSymbol(tree))) {
                    fix.replace(tree, replacement);
                }
            }
        });
        return fix.build();
    }

    public static SuggestedFix renameMethod(MethodTree tree, String replacement, VisitorState state) {
        int basePos = ((JCTree)((Object)tree)).getStartPosition();
        int endPos = tree.getBody() != null ? ((JCTree)((Object)tree.getBody())).getStartPosition() : state.getEndPosition(tree);
        ImmutableList<ErrorProneToken> methodTokens = ErrorProneTokens.getTokens(state.getSourceCode().subSequence(basePos, endPos).toString(), state.context);
        for (ErrorProneToken token : methodTokens) {
            if (token.kind() != Tokens.TokenKind.IDENTIFIER || !token.name().equals(tree.getName())) continue;
            int nameStartPosition = basePos + token.pos();
            int nameEndPosition = basePos + token.endPos();
            return SuggestedFix.builder().replace(nameStartPosition, nameEndPosition, replacement).build();
        }
        throw new AssertionError();
    }

    public static SuggestedFix renameMethodInvocation(MethodInvocationTree tree, String replacement, VisitorState state) {
        int startPos;
        ExpressionTree methodSelect = tree.getMethodSelect();
        String extra = "";
        if (methodSelect instanceof MemberSelectTree) {
            startPos = state.getEndPosition(((MemberSelectTree)methodSelect).getExpression());
            extra = ".";
        } else if (methodSelect instanceof IdentifierTree) {
            startPos = ((JCTree)((Object)tree)).getStartPosition();
        } else {
            return SuggestedFix.builder().build();
        }
        int endPos = state.getEndPosition(methodSelect);
        return SuggestedFix.replace(startPos, endPos, extra + replacement);
    }

    public static Fix deleteExceptions(MethodTree tree, final VisitorState state, java.util.List<ExpressionTree> toDelete) {
        java.util.List<? extends ExpressionTree> trees = tree.getThrows();
        if (toDelete.size() == trees.size()) {
            return SuggestedFix.replace(SuggestedFixes.getThrowsPosition(tree, state) - 1, state.getEndPosition((Tree)Iterables.getLast(trees)), "");
        }
        String replacement = FluentIterable.from(tree.getThrows()).filter(Predicates.not((com.google.common.base.Predicate)Predicates.in(toDelete))).transform((Function)new Function<ExpressionTree, String>(){

            @Nullable
            public String apply(ExpressionTree input) {
                return state.getSourceForNode(input);
            }
        }).join(Joiner.on((String)", "));
        return SuggestedFix.replace(((JCTree)((Object)tree.getThrows().get(0))).getStartPosition(), state.getEndPosition((Tree)Iterables.getLast(tree.getThrows())), replacement);
    }

    private static int getThrowsPosition(MethodTree tree, VisitorState state) {
        for (ErrorProneToken token : state.getTokensForNode(tree)) {
            if (token.kind() != Tokens.TokenKind.THROWS) continue;
            return ((JCTree)((Object)tree)).getStartPosition() + token.pos();
        }
        throw new AssertionError();
    }

    @Nullable
    public static Fix addSuppressWarnings(VisitorState state, String warningToSuppress) {
        return SuggestedFixes.addSuppressWarnings(state, warningToSuppress, null);
    }

    @Nullable
    public static Fix addSuppressWarnings(VisitorState state, String warningToSuppress, @Nullable String lineComment) {
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        SuggestedFixes.addSuppressWarnings(fixBuilder, state, warningToSuppress, lineComment);
        return fixBuilder.isEmpty() ? null : fixBuilder.build();
    }

    public static void addSuppressWarnings(SuggestedFix.Builder fixBuilder, VisitorState state, String warningToSuppress) {
        SuggestedFixes.addSuppressWarnings(fixBuilder, state, warningToSuppress, null);
    }

    public static void addSuppressWarnings(SuggestedFix.Builder fixBuilder, VisitorState state, String warningToSuppress, @Nullable String lineComment) {
        Tree suppressibleNode = SuggestedFixes.suppressibleNode(state.getPath());
        if (suppressibleNode == null) {
            return;
        }
        SuppressWarnings existingAnnotation = ASTHelpers.getAnnotation(suppressibleNode, SuppressWarnings.class);
        String suppression = state.getTreeMaker().Literal(TypeTag.CLASS, warningToSuppress).toString();
        Optional<String> formattedLineComment = Optional.ofNullable(lineComment).map(s -> "// " + s + "\n");
        if (existingAnnotation != null) {
            String[] values = existingAnnotation.value();
            if (Arrays.asList(values).contains(warningToSuppress)) {
                return;
            }
            AnnotationTree suppressAnnotationTree = ASTHelpers.getAnnotationWithSimpleName(SuggestedFixes.findAnnotationsTree(suppressibleNode), SuppressWarnings.class.getSimpleName());
            if (suppressAnnotationTree == null) {
                return;
            }
            fixBuilder.merge(SuggestedFixes.addValuesToAnnotationArgument(suppressAnnotationTree, "value", (Collection<String>)ImmutableList.of((Object)suppression), state));
            formattedLineComment.ifPresent(lc -> fixBuilder.prefixWith(suppressAnnotationTree, (String)lc));
        } else {
            String replacement = formattedLineComment.orElse("") + "@SuppressWarnings(" + suppression + ") ";
            fixBuilder.prefixWith(suppressibleNode, replacement);
        }
    }

    private static java.util.List<? extends AnnotationTree> findAnnotationsTree(Tree tree) {
        ModifiersTree maybeModifiers = ASTHelpers.getModifiers(tree);
        return maybeModifiers == null ? ImmutableList.of() : maybeModifiers.getAnnotations();
    }

    @Nullable
    private static Tree suppressibleNode(TreePath path) {
        return StreamSupport.stream(path.spliterator(), false).filter(tree -> tree instanceof MethodTree || tree instanceof ClassTree && ((ClassTree)tree).getSimpleName().length() != 0 || tree instanceof VariableTree).findFirst().orElse(null);
    }

    public static SuggestedFix.Builder addValuesToAnnotationArgument(AnnotationTree annotation, String parameterName, Collection<String> newValues, VisitorState state) {
        if (annotation.getArguments().isEmpty()) {
            String parameterPrefix = parameterName.equals("value") ? "" : parameterName + " = ";
            return SuggestedFix.builder().replace(annotation, annotation.toString().replaceFirst("\\(\\)", "(" + parameterPrefix + SuggestedFixes.newArgument(newValues) + ")"));
        }
        Optional<ExpressionTree> maybeExistingArgument = SuggestedFixes.findArgument(annotation, parameterName);
        if (!maybeExistingArgument.isPresent()) {
            return SuggestedFix.builder().prefixWith(annotation.getArguments().get(0), parameterName + " = " + SuggestedFixes.newArgument(newValues) + ", ");
        }
        ExpressionTree existingArgument = maybeExistingArgument.get();
        if (!existingArgument.getKind().equals((Object)Tree.Kind.NEW_ARRAY)) {
            return SuggestedFix.builder().replace(existingArgument, SuggestedFixes.newArgument(state.getSourceForNode(existingArgument), newValues));
        }
        NewArrayTree newArray = (NewArrayTree)existingArgument;
        if (newArray.getInitializers().isEmpty()) {
            return SuggestedFix.builder().replace(newArray, SuggestedFixes.newArgument(newValues));
        }
        return SuggestedFix.builder().postfixWith((Tree)Iterables.getLast(newArray.getInitializers()), ", " + Joiner.on((String)", ").join(newValues));
    }

    public static SuggestedFix.Builder updateAnnotationArgumentValues(AnnotationTree annotation, String parameterName, Collection<String> newValues) {
        if (annotation.getArguments().isEmpty()) {
            String parameterPrefix = parameterName.equals("value") ? "" : parameterName + " = ";
            return SuggestedFix.builder().replace(annotation, annotation.toString().replaceFirst("\\(\\)", "(" + parameterPrefix + SuggestedFixes.newArgument(newValues) + ")"));
        }
        Optional<ExpressionTree> maybeExistingArgument = SuggestedFixes.findArgument(annotation, parameterName);
        if (!maybeExistingArgument.isPresent()) {
            return SuggestedFix.builder().prefixWith(annotation.getArguments().get(0), parameterName + " = " + SuggestedFixes.newArgument(newValues) + ", ");
        }
        ExpressionTree existingArgument = maybeExistingArgument.get();
        return SuggestedFix.builder().replace(existingArgument, SuggestedFixes.newArgument(newValues));
    }

    private static String newArgument(String existingParameters, Collection<String> initializers) {
        return SuggestedFixes.newArgument((Collection<String>)ImmutableList.builder().add((Object)existingParameters).addAll(initializers).build());
    }

    private static String newArgument(Collection<String> initializers) {
        StringBuilder expression = new StringBuilder();
        if (initializers.size() > 1) {
            expression.append('{');
        }
        Joiner.on((String)", ").appendTo(expression, initializers);
        if (initializers.size() > 1) {
            expression.append('}');
        }
        return expression.toString();
    }

    private static Optional<ExpressionTree> findArgument(AnnotationTree annotation, String parameter) {
        for (ExpressionTree expressionTree : annotation.getArguments()) {
            AssignmentTree assignment;
            if (!expressionTree.getKind().equals((Object)Tree.Kind.ASSIGNMENT) || !(assignment = (AssignmentTree)expressionTree).getVariable().toString().equals(parameter)) continue;
            return Optional.of(ASTHelpers.stripParentheses(assignment.getExpression()));
        }
        return Optional.empty();
    }

    public static boolean compilesWithFix(Fix fix, VisitorState state) {
        if (fix.isEmpty()) {
            return true;
        }
        JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)state.getPath().getCompilationUnit();
        JavaFileObject modifiedFile = compilationUnit.getSourceFile();
        BasicJavacTask javacTask = (BasicJavacTask)state.context.get(JavacTask.class);
        if (javacTask == null) {
            throw new IllegalArgumentException("No JavacTask in context.");
        }
        Arguments arguments = Arguments.instance(javacTask.getContext());
        ArrayList<JavaFileObject> fileObjects = new ArrayList<JavaFileObject>(arguments.getFileObjects());
        for (int i = 0; i < fileObjects.size(); ++i) {
            SourceFile fixSource;
            JavaFileObject oldFile = (JavaFileObject)fileObjects.get(i);
            if (!modifiedFile.toUri().equals(oldFile.toUri())) continue;
            DescriptionBasedDiff diff = DescriptionBasedDiff.create(compilationUnit, ImportOrganizer.STATIC_FIRST_ORGANIZER);
            diff.handleFix(fix);
            try {
                fixSource = new SourceFile(modifiedFile.getName(), modifiedFile.getCharContent(false));
            }
            catch (IOException e) {
                return false;
            }
            diff.applyDifferences(fixSource);
            fileObjects.set(i, new SimpleJavaFileObject(SuggestedFixes.sourceURI(modifiedFile.toUri()), JavaFileObject.Kind.SOURCE){

                @Override
                public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                    return fixSource.getAsSequence();
                }
            });
            break;
        }
        DiagnosticCollector<JavaFileObject> diagnosticListener = new DiagnosticCollector<JavaFileObject>();
        Context context = new Context();
        Options options = Options.instance(context);
        Options originalOptions = Options.instance(javacTask.getContext());
        for (String key : originalOptions.keySet()) {
            String value = originalOptions.get(key);
            if (key.equals("-Xplugin:") && value.startsWith("ErrorProne")) continue;
            options.put(key, value);
        }
        JavacTask newTask = JavacTool.create().getTask(CharStreams.nullWriter(), state.context.get(JavaFileManager.class), diagnosticListener, (Iterable<String>)ImmutableList.of(), arguments.getClassNames(), fileObjects, context);
        try {
            newTask.analyze();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return SuggestedFixes.countErrors(diagnosticListener) == 0L;
    }

    @VisibleForTesting
    static URI sourceURI(URI uri) {
        if (!uri.getScheme().equals("jar")) {
            return uri;
        }
        try {
            return URI.create("file:/" + ((JarURLConnection)uri.toURL().openConnection()).getEntryName());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static long countErrors(DiagnosticCollector<JavaFileObject> diagnosticCollector) {
        return diagnosticCollector.getDiagnostics().stream().filter(d -> d.getKind() == Diagnostic.Kind.ERROR).count();
    }

    public static String prettyType(final @Nullable VisitorState state, final @Nullable SuggestedFix.Builder fix, Type type) {
        return type.accept(new Types.DefaultTypeVisitor<String, Void>(){

            @Override
            public String visitWildcardType(Type.WildcardType t, Void unused) {
                StringBuilder sb = new StringBuilder();
                sb.append((Object)t.kind);
                if (t.kind != BoundKind.UNBOUND) {
                    sb.append(t.type.accept(this, null));
                }
                return sb.toString();
            }

            @Override
            public String visitClassType(Type.ClassType t, Void unused) {
                StringBuilder sb = new StringBuilder();
                if (state == null || fix == null) {
                    sb.append(t.tsym.getSimpleName());
                } else {
                    sb.append(SuggestedFixes.qualifyType(state, fix, t.tsym));
                }
                if (((List)t.getTypeArguments()).nonEmpty()) {
                    sb.append('<');
                    sb.append(t.getTypeArguments().stream().map(a -> a.accept(this, null)).collect(Collectors.joining(", ")));
                    sb.append(">");
                }
                return sb.toString();
            }

            @Override
            public String visitCapturedType(Type.CapturedType t, Void unused) {
                return t.wildcard.accept(this, null);
            }

            @Override
            public String visitArrayType(Type.ArrayType t, Void unused) {
                return t.elemtype.accept(this, null) + "[]";
            }

            @Override
            public String visitType(Type t, Void unused) {
                return t.toString();
            }
        }, null);
    }

    public static Optional<SuggestedFix> suggestWhitelistAnnotation(String whitelistAnnotation, TreePath where, VisitorState state) {
        String annotationName;
        ImmutableSet<Tree.Kind> supportedWhitelistLocationKinds;
        if (whitelistAnnotation.equals("com.google.errorprone.annotations.DontSuggestFixes")) {
            return Optional.empty();
        }
        SuggestedFix.Builder builder = SuggestedFix.builder();
        Type whitelistAnnotationType = state.getTypeFromString(whitelistAnnotation);
        if (whitelistAnnotationType != null) {
            supportedWhitelistLocationKinds = SuggestedFixes.supportedTreeTypes(whitelistAnnotationType.asElement());
            annotationName = SuggestedFixes.qualifyType(state, builder, whitelistAnnotationType);
        } else {
            int idx = whitelistAnnotation.lastIndexOf(46);
            Verify.verify((idx > 0 && idx + 1 < whitelistAnnotation.length() ? 1 : 0) != 0);
            supportedWhitelistLocationKinds = TREE_TYPE_UNKNOWN_ANNOTATION;
            annotationName = whitelistAnnotation.substring(idx + 1);
            builder.addImport(whitelistAnnotation);
        }
        Optional<Tree> whitelistLocation = StreamSupport.stream(where.spliterator(), false).filter(tree -> supportedWhitelistLocationKinds.contains((Object)tree.getKind())).filter((Predicate<Tree>)Predicates.not(SuggestedFixes::isAnonymousClassTree)).findFirst();
        return whitelistLocation.map(location -> builder.prefixWith((Tree)location, "@" + annotationName + " ").build());
    }

    private static boolean isAnonymousClassTree(Tree t) {
        if (t instanceof ClassTree) {
            ClassTree classTree = (ClassTree)t;
            return classTree.getSimpleName().contentEquals("");
        }
        return false;
    }

    public static boolean suggestedWhitelistAnnotationSupported(Element whitelistAnnotation) {
        return !SuggestedFixes.supportedTreeTypes(whitelistAnnotation).isEmpty();
    }

    private static ImmutableSet<Tree.Kind> supportedTreeTypes(Element whitelistAnnotation) {
        Target targetAnnotation = whitelistAnnotation.getAnnotation(Target.class);
        if (targetAnnotation == null) {
            return TREE_TYPE_UNKNOWN_ANNOTATION;
        }
        ImmutableSet.Builder types = ImmutableSet.builder();
        block4: for (ElementType t : targetAnnotation.value()) {
            switch (t) {
                case TYPE: {
                    types.add((Object[])new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE});
                    continue block4;
                }
                case METHOD: {
                    types.add((Object)Tree.Kind.METHOD);
                    continue block4;
                }
            }
        }
        return types.build();
    }

    /*
     * WARNING - void declaration
     */
    public static SuggestedFix replaceIncludingComments(TreePath path, String replacement, VisitorState state) {
        Tokens.Comment comment;
        int endOfCommentPos;
        String stringBetweenComments;
        void var9_11;
        Tree tree = path.getLeaf();
        Tree parent = path.getParentPath().getLeaf();
        if (!(parent instanceof ClassTree)) {
            return SuggestedFix.replace(tree, replacement);
        }
        Tree previousMember = null;
        ClassTree classTree = (ClassTree)parent;
        for (Tree tree2 : classTree.getMembers()) {
            if (tree2 instanceof MethodTree && ASTHelpers.isGeneratedConstructor((MethodTree)tree2)) continue;
            if (tree2.equals(tree)) break;
            previousMember = tree2;
        }
        int startTokenization = previousMember != null ? state.getEndPosition(previousMember) : (state.getEndPosition(classTree.getModifiers()) == -1 ? ((JCTree)((Object)classTree)).getStartPosition() : state.getEndPosition(classTree.getModifiers()));
        String source = state.getSourceCode().subSequence(startTokenization, state.getEndPosition(tree)).toString();
        ImmutableList<ErrorProneToken> immutableList = ErrorProneTokens.getTokens(source, state.context);
        if (previousMember == null) {
            ImmutableList<ErrorProneToken> immutableList2 = SuggestedFixes.getTokensAfterOpeningBrace(immutableList);
        }
        if (var9_11.isEmpty()) {
            return SuggestedFix.replace(tree, replacement);
        }
        if (((ErrorProneToken)var9_11.get(0)).comments().isEmpty()) {
            return SuggestedFix.replace(startTokenization + ((ErrorProneToken)var9_11.get(0)).pos(), state.getEndPosition(tree), replacement);
        }
        ImmutableList comments = ImmutableList.sortedCopyOf(Comparator.comparingInt(c -> c.getSourcePos(0)).reversed(), ((ErrorProneToken)var9_11.get(0)).comments());
        int startPos = ((JCTree)tree).getStartPosition() - startTokenization;
        if (startPos < 0) {
            return SuggestedFix.builder().build();
        }
        UnmodifiableIterator unmodifiableIterator = comments.iterator();
        while (unmodifiableIterator.hasNext() && (stringBetweenComments = source.substring(endOfCommentPos = (comment = (Tokens.Comment)unmodifiableIterator.next()).getSourcePos(comment.getText().length() - 1), startPos)).chars().filter(c -> c == 10).count() <= 1L) {
            startPos = comment.getSourcePos(0);
        }
        return SuggestedFix.replace(startTokenization + startPos, state.getEndPosition(tree), replacement);
    }

    private static ImmutableList<ErrorProneToken> getTokensAfterOpeningBrace(ImmutableList<ErrorProneToken> tokens) {
        for (int i = 0; i < tokens.size() - 1; ++i) {
            if (((ErrorProneToken)tokens.get(i)).kind() != Tokens.TokenKind.LBRACE) continue;
            return tokens.subList(i + 1, tokens.size());
        }
        return ImmutableList.of();
    }
}

