/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Options;
import java.util.HashMap;
import java.util.Map;

public enum Target {
    JDK1_1("1.1", 45, 3),
    JDK1_2("1.2", 46, 0),
    JDK1_3("1.3", 47, 0),
    JDK1_4("1.4", 48, 0),
    JDK1_5("1.5", 49, 0),
    JDK1_6("1.6", 50, 0),
    JDK1_7("1.7", 51, 0),
    JDK1_8("1.8", 52, 0),
    JDK1_9("1.9", 53, 0),
    JDK1_10("1.10", 54, 0),
    JDK1_11("11", 55, 0);

    private static final Context.Key<Target> targetKey;
    public static final Target MIN;
    private static final Target MAX;
    private static final Map<String, Target> tab;
    public final String name;
    public final int majorVersion;
    public final int minorVersion;
    public static final Target DEFAULT;

    public static Target instance(Context context) {
        Target instance = context.get(targetKey);
        if (instance == null) {
            Options options = Options.instance(context);
            String targetString = options.get(Option.TARGET);
            if (targetString != null) {
                instance = Target.lookup(targetString);
            }
            if (instance == null) {
                instance = DEFAULT;
            }
            context.put(targetKey, instance);
        }
        return instance;
    }

    private Target(String name, int majorVersion, int minorVersion) {
        this.name = name;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public static Target lookup(String name) {
        return tab.get(name);
    }

    public char syntheticNameChar() {
        return '$';
    }

    public boolean hasInvokedynamic() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean hasObjects() {
        return this.compareTo(JDK1_7) >= 0;
    }

    public boolean hasMethodParameters() {
        return this.compareTo(JDK1_8) >= 0;
    }

    public boolean hasMethodHandles() {
        return this.hasInvokedynamic();
    }

    public boolean hasStringConcatFactory() {
        return this.compareTo(JDK1_9) >= 0;
    }

    public String multiReleaseValue() {
        return Integer.toString(this.ordinal() - JDK1_1.ordinal() + 1);
    }

    public boolean allApiModulesAreRoots() {
        return this.compareTo(JDK1_11) >= 0;
    }

    public boolean hasNestmateAccess() {
        return this.compareTo(JDK1_11) >= 0;
    }

    public boolean hasVirtualPrivateInvoke() {
        return this.compareTo(JDK1_11) >= 0;
    }

    static {
        targetKey = new Context.Key();
        MIN = JDK1_6;
        MAX = Target.values()[Target.values().length - 1];
        tab = new HashMap<String, Target>();
        for (Target t : Target.values()) {
            tab.put(t.name, t);
        }
        tab.put("5", JDK1_5);
        tab.put("6", JDK1_6);
        tab.put("7", JDK1_7);
        tab.put("8", JDK1_8);
        tab.put("9", JDK1_9);
        tab.put("10", JDK1_10);
        tab.put("11", JDK1_11);
        DEFAULT = Target.values()[Target.values().length - 1];
    }
}

