/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.record;

import com.hazelcast.replicatedmap.impl.record.ReplicatedRecord;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class InternalReplicatedMapStorage<K, V> {
    private final ConcurrentMap<K, ReplicatedRecord<K, V>> storage = new ConcurrentHashMap<K, ReplicatedRecord<K, V>>(1000, 0.75f, 1);
    private AtomicLong version = new AtomicLong();

    public long getVersion() {
        return this.version.get();
    }

    public void setVersion(long version) {
        this.version.set(version);
    }

    public void incrementVersion() {
        this.version.incrementAndGet();
    }

    public ReplicatedRecord<K, V> get(Object key) {
        return (ReplicatedRecord)this.storage.get(key);
    }

    public ReplicatedRecord<K, V> put(K key, ReplicatedRecord<K, V> replicatedRecord) {
        this.version.incrementAndGet();
        return this.storage.put(key, replicatedRecord);
    }

    public ReplicatedRecord<K, V> putInternal(K key, ReplicatedRecord<K, V> replicatedRecord) {
        return this.storage.put(key, replicatedRecord);
    }

    public boolean remove(K key, ReplicatedRecord<K, V> replicatedRecord) {
        this.version.incrementAndGet();
        return this.storage.remove(key, replicatedRecord);
    }

    public boolean containsKey(Object key) {
        return this.storage.containsKey(key);
    }

    public Set<Map.Entry<K, ReplicatedRecord<K, V>>> entrySet() {
        return this.storage.entrySet();
    }

    public Collection<ReplicatedRecord<K, V>> values() {
        return this.storage.values();
    }

    public Set<K> keySet() {
        return this.storage.keySet();
    }

    public void clear() {
        this.version.incrementAndGet();
        this.storage.clear();
    }

    public void reset() {
        this.storage.clear();
        this.version.set(0L);
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public int size() {
        int count = 0;
        for (ReplicatedRecord record : this.storage.values()) {
            if (record.isTombstone()) continue;
            ++count;
        }
        return count;
    }
}

