/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.map.impl.client.AbstractMapQueryRequest;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.TruePredicate;
import com.hazelcast.util.IterationType;
import java.io.IOException;

public final class MapQueryRequest
extends AbstractMapQueryRequest {
    private Predicate predicate;

    public MapQueryRequest() {
    }

    public MapQueryRequest(String name, Predicate predicate, IterationType iterationType) {
        super(name, iterationType);
        this.predicate = predicate;
    }

    @Override
    public int getClassId() {
        return 34;
    }

    @Override
    public String getMethodName() {
        if (this.iterationType == IterationType.KEY) {
            return "keySet";
        }
        if (this.iterationType == IterationType.VALUE) {
            return "values";
        }
        if (this.iterationType == IterationType.ENTRY) {
            return "entrySet";
        }
        throw new IllegalArgumentException("IterationType[" + (Object)((Object)this.iterationType) + "] is unknown!!!");
    }

    @Override
    public Object[] getParameters() {
        Object[] objectArray;
        if (this.predicate == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.predicate;
        }
        return objectArray;
    }

    @Override
    protected Predicate getPredicate() {
        return this.predicate == null ? TruePredicate.INSTANCE : this.predicate;
    }

    @Override
    protected void writePortableInner(PortableWriter writer) throws IOException {
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeObject(this.predicate);
    }

    @Override
    protected void readPortableInner(PortableReader reader) throws IOException {
        ObjectDataInput in = reader.getRawDataInput();
        this.predicate = (Predicate)in.readObject();
    }
}

