/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.FilterableList;

public interface AnnotationList
extends FilterableList<AnnotationDescription, AnnotationList> {
    public boolean isAnnotationPresent(Class<? extends Annotation> var1);

    public boolean isAnnotationPresent(TypeDescription var1);

    public <T extends Annotation> AnnotationDescription.Loadable<T> ofType(Class<T> var1);

    public AnnotationList inherited(Set<? extends TypeDescription> var1);

    public AnnotationList visibility(ElementMatcher<? super RetentionPolicy> var1);

    public static class Empty
    extends FilterableList.Empty<AnnotationDescription, AnnotationList>
    implements AnnotationList {
        public static List<AnnotationList> asList(int length) {
            ArrayList<AnnotationList> result = new ArrayList<AnnotationList>(length);
            for (int i = 0; i < length; ++i) {
                result.add(new Empty());
            }
            return result;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return false;
        }

        @Override
        public boolean isAnnotationPresent(TypeDescription annotationType) {
            return false;
        }

        @Override
        public <T extends Annotation> AnnotationDescription.Loadable<T> ofType(Class<T> annotationType) {
            return null;
        }

        @Override
        public AnnotationList inherited(Set<? extends TypeDescription> ignoredTypes) {
            return this;
        }

        @Override
        public AnnotationList visibility(ElementMatcher<? super RetentionPolicy> matcher) {
            return this;
        }
    }

    public static class Explicit
    extends AbstractBase {
        private final List<? extends AnnotationDescription> annotationDescriptions;

        public Explicit(List<? extends AnnotationDescription> annotationDescriptions) {
            this.annotationDescriptions = annotationDescriptions;
        }

        public static List<AnnotationList> asList(List<? extends List<? extends AnnotationDescription>> annotations) {
            ArrayList<AnnotationList> result = new ArrayList<AnnotationList>(annotations.size());
            for (List<? extends AnnotationDescription> list : annotations) {
                result.add(new Explicit(list));
            }
            return result;
        }

        @Override
        public AnnotationDescription get(int index) {
            return this.annotationDescriptions.get(index);
        }

        @Override
        public int size() {
            return this.annotationDescriptions.size();
        }
    }

    public static class ForLoadedAnnotation
    extends AbstractBase {
        private final List<? extends Annotation> annotations;

        public ForLoadedAnnotation(Annotation ... annotation) {
            this(Arrays.asList(annotation));
        }

        public ForLoadedAnnotation(List<? extends Annotation> annotations) {
            this.annotations = annotations;
        }

        public static List<AnnotationList> asList(Annotation[][] annotations) {
            ArrayList<AnnotationList> result = new ArrayList<AnnotationList>(annotations.length);
            for (Annotation[] annotation : annotations) {
                result.add(new ForLoadedAnnotation(annotation));
            }
            return result;
        }

        @Override
        public AnnotationDescription get(int index) {
            return AnnotationDescription.ForLoadedAnnotation.of(this.annotations.get(index));
        }

        @Override
        public int size() {
            return this.annotations.size();
        }
    }

    public static abstract class AbstractBase
    extends FilterableList.AbstractBase<AnnotationDescription, AnnotationList>
    implements AnnotationList {
        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            for (AnnotationDescription annotation : this) {
                if (!annotation.getAnnotationType().represents(annotationType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isAnnotationPresent(TypeDescription annotationType) {
            for (AnnotationDescription annotation : this) {
                if (!annotation.getAnnotationType().equals(annotationType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends Annotation> AnnotationDescription.Loadable<T> ofType(Class<T> annotationType) {
            for (AnnotationDescription annotation : this) {
                if (!annotation.getAnnotationType().represents(annotationType)) continue;
                return annotation.prepare(annotationType);
            }
            return null;
        }

        @Override
        public AnnotationList inherited(Set<? extends TypeDescription> ignoredTypes) {
            ArrayList<AnnotationDescription> inherited = new ArrayList<AnnotationDescription>(this.size());
            for (AnnotationDescription annotation : this) {
                if (ignoredTypes.contains(annotation.getAnnotationType()) || !annotation.isInherited()) continue;
                inherited.add(annotation);
            }
            return this.wrap(inherited);
        }

        @Override
        public AnnotationList visibility(ElementMatcher<? super RetentionPolicy> matcher) {
            ArrayList<AnnotationDescription> annotationDescriptions = new ArrayList<AnnotationDescription>(this.size());
            for (AnnotationDescription annotation : this) {
                if (!matcher.matches(annotation.getRetention())) continue;
                annotationDescriptions.add(annotation);
            }
            return this.wrap(annotationDescriptions);
        }

        @Override
        protected AnnotationList wrap(List<AnnotationDescription> values) {
            return new Explicit(values);
        }
    }
}

