/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import javax.lang.model.element.Modifier;

@BugPattern(name="InjectScopeAnnotationOnInterfaceOrAbstractClass", summary="Scope annotation on an interface or abstact class is not allowed", explanation="Scoping annotations are not allowed on abstract types.", category=BugPattern.Category.INJECT, severity=BugPattern.SeverityLevel.ERROR)
public class ScopeAnnotationOnInterfaceOrAbstractClass
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    private static final Matcher<AnnotationTree> SCOPE_ANNOTATION_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.hasAnnotation((String)"com.google.inject.ScopeAnnotation"), Matchers.hasAnnotation((String)"javax.inject.Scope")});
    private static final Matcher<ClassTree> INTERFACE_AND_ABSTRACT_TYPE_MATCHER = new Matcher<ClassTree>(){

        public boolean matches(ClassTree classTree, VisitorState state) {
            return classTree.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT) || (ASTHelpers.getSymbol((ClassTree)classTree).flags() & 0x200L) != 0L;
        }
    };

    public final Description matchAnnotation(AnnotationTree annotationTree, VisitorState state) {
        Tree modified = this.getCurrentlyAnnotatedNode(state);
        if (SCOPE_ANNOTATION_MATCHER.matches((Tree)annotationTree, state) && modified instanceof ClassTree && !InjectMatchers.IS_DAGGER_COMPONENT.matches((Tree)((ClassTree)modified), state) && INTERFACE_AND_ABSTRACT_TYPE_MATCHER.matches((Tree)((ClassTree)modified), state)) {
            return this.describeMatch(annotationTree, (Fix)SuggestedFix.delete((Tree)annotationTree));
        }
        return Description.NO_MATCH;
    }

    private Tree getCurrentlyAnnotatedNode(VisitorState state) {
        return state.getPath().getParentPath().getParentPath().getLeaf();
    }
}

