/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.names.LevenshteinEditDistance;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.ElementKind;

@BugPattern(name="ModifyingCollectionWithItself", summary="Using a collection function with itself as the argument.", explanation="Invoking a collection method with the same collection as the argument is likely incorrect.\n\n* `collection.addAll(collection)` may cause an infinite loop, duplicate the elements, or do nothing, depending on the type of Collection and implementation class.\n* `collection.retainAll(collection)` is a no-op.\n* `collection.removeAll(collection)` is the same as `collection.clear()`.\n* `collection.containsAll(collection)` is always true.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR)
public class ModifyingCollectionWithItself
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> IS_COLLECTION_MODIFIED_WITH_ITSELF = ModifyingCollectionWithItself.buildMatcher();

    private static Matcher<MethodInvocationTree> buildMatcher() {
        return Matchers.anyOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("java.util.Collection").named("addAll"), Matchers.instanceMethod().onDescendantOf("java.util.Collection").named("removeAll"), Matchers.instanceMethod().onDescendantOf("java.util.Collection").named("containsAll"), Matchers.instanceMethod().onDescendantOf("java.util.Collection").named("retainAll")}), Matchers.receiverSameAsArgument((int)0)}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onDescendantOf("java.util.Collection").named("addAll"), Matchers.receiverSameAsArgument((int)1)})});
    }

    public Description matchMethodInvocation(MethodInvocationTree t, VisitorState state) {
        if (IS_COLLECTION_MODIFIED_WITH_ITSELF.matches((Tree)t, state)) {
            return this.describe(t, state);
        }
        return Description.NO_MATCH;
    }

    private Description describe(MethodInvocationTree methodInvocationTree, VisitorState state) {
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)methodInvocationTree);
        List<? extends ExpressionTree> arguments = methodInvocationTree.getArguments();
        ExpressionTree argument = arguments.size() == 2 ? arguments.get(1) : arguments.get(0);
        Description.Builder builder = this.buildDescription(methodInvocationTree);
        for (Fix fix : this.buildFixes(methodInvocationTree, state, receiver, argument)) {
            builder.addFix(fix);
        }
        return builder.build();
    }

    private List<Fix> buildFixes(MethodInvocationTree methodInvocationTree, VisitorState state, ExpressionTree receiver, ExpressionTree argument) {
        List<Fix> fixes;
        if (receiver.getKind() == Tree.Kind.MEMBER_SELECT) {
            fixes = this.fixesFromMethodParameters(state, argument);
        } else {
            assert (receiver.getKind() == Tree.Kind.IDENTIFIER);
            boolean lhsIsField = ASTHelpers.getSymbol((Tree)receiver).getKind() == ElementKind.FIELD;
            List<Fix> list = fixes = lhsIsField ? this.fixesFromMethodParameters(state, argument) : this.fixesFromFields(state, receiver);
        }
        if (fixes.isEmpty()) {
            fixes = this.literalReplacement(methodInvocationTree, state, receiver);
        }
        return fixes;
    }

    private List<Fix> fixesFromFields(VisitorState state, final ExpressionTree receiver) {
        FluentIterable collectionFields = FluentIterable.from((Iterable)((JCTree.JCClassDecl)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), JCTree.JCClassDecl.class)).getMembers()).filter(JCTree.JCVariableDecl.class).filter(this.isCollectionVariable(state));
        Multimap<Integer, JCTree.JCVariableDecl> potentialReplacements = this.partitionByEditDistance(this.simpleNameOfIdentifierOrMemberAccess(receiver), (Iterable<JCTree.JCVariableDecl>)collectionFields);
        return this.buildValidReplacements(potentialReplacements, new Function<JCTree.JCVariableDecl, Fix>(){

            public Fix apply(JCTree.JCVariableDecl var) {
                return SuggestedFix.replace((Tree)receiver, (String)("this." + var.sym.toString()));
            }
        });
    }

    private List<Fix> buildValidReplacements(Multimap<Integer, JCTree.JCVariableDecl> potentialReplacements, Function<JCTree.JCVariableDecl, Fix> replacementFunction) {
        if (potentialReplacements.isEmpty()) {
            return ImmutableList.of();
        }
        return FluentIterable.from((Iterable)potentialReplacements.get(Collections.min(potentialReplacements.keySet()))).transform(replacementFunction).toList();
    }

    private Predicate<JCTree.JCVariableDecl> isCollectionVariable(final VisitorState state) {
        return new Predicate<JCTree.JCVariableDecl>(){

            public boolean apply(JCTree.JCVariableDecl var) {
                return Matchers.variableType((Matcher)Matchers.isSubtypeOf((String)"java.util.Collection")).matches((Tree)var, state);
            }
        };
    }

    private List<Fix> fixesFromMethodParameters(VisitorState state, final ExpressionTree argument) {
        assert (argument.getKind() == Tree.Kind.IDENTIFIER || argument.getKind() == Tree.Kind.MEMBER_SELECT);
        FluentIterable collectionParams = FluentIterable.from((Iterable)((JCTree.JCMethodDecl)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), JCTree.JCMethodDecl.class)).getParameters()).filter(this.isCollectionVariable(state));
        Multimap<Integer, JCTree.JCVariableDecl> potentialReplacements = this.partitionByEditDistance(this.simpleNameOfIdentifierOrMemberAccess(argument), (Iterable<JCTree.JCVariableDecl>)collectionParams);
        return this.buildValidReplacements(potentialReplacements, new Function<JCTree.JCVariableDecl, Fix>(){

            public Fix apply(JCTree.JCVariableDecl var) {
                return SuggestedFix.replace((Tree)argument, (String)var.sym.toString());
            }
        });
    }

    private Multimap<Integer, JCTree.JCVariableDecl> partitionByEditDistance(final String baseName, Iterable<JCTree.JCVariableDecl> candidates) {
        return Multimaps.index(candidates, (Function)new Function<JCTree.JCVariableDecl, Integer>(){

            public Integer apply(JCTree.JCVariableDecl jcVariableDecl) {
                return LevenshteinEditDistance.getEditDistance((String)baseName, (String)jcVariableDecl.name.toString());
            }
        });
    }

    private String simpleNameOfIdentifierOrMemberAccess(ExpressionTree tree) {
        String name = null;
        if (tree.getKind() == Tree.Kind.IDENTIFIER) {
            name = ((JCTree.JCIdent)tree).name.toString();
        } else if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            name = ((JCTree.JCFieldAccess)tree).name.toString();
        }
        return name;
    }

    private List<Fix> literalReplacement(MethodInvocationTree methodInvocationTree, VisitorState state, ExpressionTree lhs) {
        Tree parent = state.getPath().getParentPath().getLeaf();
        if (parent instanceof ExpressionStatementTree) {
            SuggestedFix fix = Matchers.instanceMethod().anyClass().named("removeAll").matches((Tree)methodInvocationTree, state) ? SuggestedFix.replace((Tree)methodInvocationTree, (String)(lhs + ".clear()")) : SuggestedFix.delete((Tree)parent);
            return ImmutableList.of((Object)fix);
        }
        return ImmutableList.of();
    }
}

