/*
 * Decompiled with CFR 0.152.
 */
package io.grpc;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.ManagedChannelBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public abstract class ManagedChannelProvider {
    private static final ManagedChannelProvider provider = ManagedChannelProvider.load(ManagedChannelProvider.class.getClassLoader());

    @VisibleForTesting
    static ManagedChannelProvider load(ClassLoader classLoader) {
        Iterable<ManagedChannelProvider> candidates = ManagedChannelProvider.isAndroid() ? ManagedChannelProvider.getCandidatesViaHardCoded() : ManagedChannelProvider.getCandidatesViaServiceLoader(classLoader);
        ArrayList<ManagedChannelProvider> list = new ArrayList<ManagedChannelProvider>();
        for (ManagedChannelProvider current : candidates) {
            if (!current.isAvailable()) continue;
            list.add(current);
        }
        if (list.isEmpty()) {
            return null;
        }
        return Collections.max(list, new Comparator<ManagedChannelProvider>(){

            @Override
            public int compare(ManagedChannelProvider f1, ManagedChannelProvider f2) {
                return f1.priority() - f2.priority();
            }
        });
    }

    @VisibleForTesting
    public static Iterable<ManagedChannelProvider> getCandidatesViaServiceLoader(ClassLoader classLoader) {
        ServiceLoader<ManagedChannelProvider> i = ServiceLoader.load(ManagedChannelProvider.class, classLoader);
        if (!i.iterator().hasNext()) {
            i = ServiceLoader.load(ManagedChannelProvider.class);
        }
        return i;
    }

    @VisibleForTesting
    public static Iterable<ManagedChannelProvider> getCandidatesViaHardCoded() {
        ArrayList<ManagedChannelProvider> list = new ArrayList<ManagedChannelProvider>();
        try {
            list.add(ManagedChannelProvider.create(Class.forName("io.grpc.okhttp.OkHttpChannelProvider")));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            list.add(ManagedChannelProvider.create(Class.forName("io.grpc.netty.NettyChannelProvider")));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return list;
    }

    @VisibleForTesting
    static ManagedChannelProvider create(Class<?> rawClass) {
        try {
            return rawClass.asSubclass(ManagedChannelProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            throw new ServiceConfigurationError("Provider " + rawClass.getName() + " could not be instantiated: " + t, t);
        }
    }

    public static ManagedChannelProvider provider() {
        if (provider == null) {
            throw new ProviderNotFoundException("No functional channel service provider found. Try adding a dependency on the grpc-okhttp or grpc-netty artifact");
        }
        return provider;
    }

    protected static boolean isAndroid() {
        try {
            Class.forName("android.app.Application", false, ManagedChannelProvider.class.getClassLoader());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected abstract boolean isAvailable();

    protected abstract int priority();

    protected abstract ManagedChannelBuilder<?> builderForAddress(String var1, int var2);

    protected abstract ManagedChannelBuilder<?> builderForTarget(String var1);

    public static final class ProviderNotFoundException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ProviderNotFoundException(String msg) {
            super(msg);
        }
    }
}

