/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

final class StringUtil {
    private StringUtil() {
    }

    static String messageFor(String message, CharSequence expected, CharSequence actual) {
        return (String)Preconditions.checkNotNull((Object)message) + "\n\nExpected:\n" + Preconditions.checkNotNull((Object)expected) + "\n\nActual:\n" + Preconditions.checkNotNull((Object)actual);
    }

    static String format(@Nullable String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }
}

