/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractProtobufList;
import com.google.protobuf.ByteString;
import com.google.protobuf.Internal;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.UnmodifiableLazyStringList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public class LazyStringArrayList
extends AbstractProtobufList<String>
implements LazyStringList,
RandomAccess {
    private static final LazyStringArrayList EMPTY_LIST = new LazyStringArrayList();
    public static final LazyStringList EMPTY;
    private final List<Object> list;

    static LazyStringArrayList emptyList() {
        return EMPTY_LIST;
    }

    public LazyStringArrayList() {
        this(10);
    }

    public LazyStringArrayList(int n) {
        this(new ArrayList<Object>(n));
    }

    public LazyStringArrayList(LazyStringList lazyStringList) {
        this.list = new ArrayList<Object>(lazyStringList.size());
        this.addAll(lazyStringList);
    }

    public LazyStringArrayList(List<String> list) {
        this(new ArrayList<Object>(list));
    }

    private LazyStringArrayList(ArrayList<Object> arrayList) {
        this.list = arrayList;
    }

    public LazyStringArrayList mutableCopyWithCapacity(int n) {
        if (n < this.size()) {
            throw new IllegalArgumentException();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        arrayList.addAll(this.list);
        return new LazyStringArrayList(arrayList);
    }

    @Override
    public String get(int n) {
        Object object = this.list.get(n);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof ByteString) {
            ByteString byteString = (ByteString)object;
            String string = byteString.toStringUtf8();
            if (byteString.isValidUtf8()) {
                this.list.set(n, string);
            }
            return string;
        }
        byte[] byArray = (byte[])object;
        String string = Internal.toStringUtf8(byArray);
        if (Internal.isValidUtf8(byArray)) {
            this.list.set(n, string);
        }
        return string;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public String set(int n, String string) {
        this.ensureIsMutable();
        Object object = this.list.set(n, string);
        return LazyStringArrayList.asString(object);
    }

    @Override
    public void add(int n, String string) {
        this.ensureIsMutable();
        this.list.add(n, string);
        ++this.modCount;
    }

    @Override
    private void add(int n, ByteString byteString) {
        this.ensureIsMutable();
        this.list.add(n, byteString);
        ++this.modCount;
    }

    @Override
    private void add(int n, byte[] byArray) {
        this.ensureIsMutable();
        this.list.add(n, byArray);
        ++this.modCount;
    }

    @Override
    public boolean addAll(Collection<? extends String> collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends String> collection) {
        this.ensureIsMutable();
        Collection<? extends String> collection2 = collection instanceof LazyStringList ? ((LazyStringList)collection).getUnderlyingElements() : collection;
        boolean bl = this.list.addAll(n, collection2);
        ++this.modCount;
        return bl;
    }

    @Override
    public boolean addAllByteString(Collection<? extends ByteString> collection) {
        this.ensureIsMutable();
        boolean bl = this.list.addAll(collection);
        ++this.modCount;
        return bl;
    }

    @Override
    public boolean addAllByteArray(Collection<byte[]> collection) {
        this.ensureIsMutable();
        boolean bl = this.list.addAll(collection);
        ++this.modCount;
        return bl;
    }

    @Override
    public String remove(int n) {
        this.ensureIsMutable();
        Object object = this.list.remove(n);
        ++this.modCount;
        return LazyStringArrayList.asString(object);
    }

    @Override
    public void clear() {
        this.ensureIsMutable();
        this.list.clear();
        ++this.modCount;
    }

    @Override
    public void add(ByteString byteString) {
        this.ensureIsMutable();
        this.list.add(byteString);
        ++this.modCount;
    }

    @Override
    public void add(byte[] byArray) {
        this.ensureIsMutable();
        this.list.add(byArray);
        ++this.modCount;
    }

    @Override
    public Object getRaw(int n) {
        return this.list.get(n);
    }

    @Override
    public ByteString getByteString(int n) {
        Object object = this.list.get(n);
        ByteString byteString = LazyStringArrayList.asByteString(object);
        if (byteString != object) {
            this.list.set(n, byteString);
        }
        return byteString;
    }

    @Override
    public byte[] getByteArray(int n) {
        Object object = this.list.get(n);
        byte[] byArray = LazyStringArrayList.asByteArray(object);
        if (byArray != object) {
            this.list.set(n, byArray);
        }
        return byArray;
    }

    @Override
    public void set(int n, ByteString byteString) {
        this.setAndReturn(n, byteString);
    }

    private Object setAndReturn(int n, ByteString byteString) {
        this.ensureIsMutable();
        return this.list.set(n, byteString);
    }

    @Override
    public void set(int n, byte[] byArray) {
        this.setAndReturn(n, byArray);
    }

    private Object setAndReturn(int n, byte[] byArray) {
        this.ensureIsMutable();
        return this.list.set(n, byArray);
    }

    private static String asString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof ByteString) {
            return ((ByteString)object).toStringUtf8();
        }
        return Internal.toStringUtf8((byte[])object);
    }

    private static ByteString asByteString(Object object) {
        if (object instanceof ByteString) {
            return (ByteString)object;
        }
        if (object instanceof String) {
            return ByteString.copyFromUtf8((String)object);
        }
        return ByteString.copyFrom((byte[])object);
    }

    private static byte[] asByteArray(Object object) {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return Internal.toByteArray((String)object);
        }
        return ((ByteString)object).toByteArray();
    }

    @Override
    public List<?> getUnderlyingElements() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public void mergeFrom(LazyStringList lazyStringList) {
        this.ensureIsMutable();
        for (Object obj : lazyStringList.getUnderlyingElements()) {
            if (obj instanceof byte[]) {
                byte[] byArray = (byte[])obj;
                this.list.add(Arrays.copyOf(byArray, byArray.length));
                continue;
            }
            this.list.add(obj);
        }
    }

    @Override
    public List<byte[]> asByteArrayList() {
        return new ByteArrayListView(this);
    }

    @Override
    public List<ByteString> asByteStringList() {
        return new ByteStringListView(this);
    }

    @Override
    public LazyStringList getUnmodifiableView() {
        if (this.isModifiable()) {
            return new UnmodifiableLazyStringList(this);
        }
        return this;
    }

    static {
        EMPTY_LIST.makeImmutable();
        EMPTY = EMPTY_LIST;
    }

    private static class ByteStringListView
    extends AbstractList<ByteString>
    implements RandomAccess {
        private final LazyStringArrayList list;

        ByteStringListView(LazyStringArrayList lazyStringArrayList) {
            this.list = lazyStringArrayList;
        }

        @Override
        public ByteString get(int n) {
            return this.list.getByteString(n);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public ByteString set(int n, ByteString byteString) {
            Object object = this.list.setAndReturn(n, byteString);
            ++this.modCount;
            return LazyStringArrayList.asByteString(object);
        }

        @Override
        public void add(int n, ByteString byteString) {
            this.list.add(n, byteString);
            ++this.modCount;
        }

        @Override
        public ByteString remove(int n) {
            String string = this.list.remove(n);
            ++this.modCount;
            return LazyStringArrayList.asByteString(string);
        }
    }

    private static class ByteArrayListView
    extends AbstractList<byte[]>
    implements RandomAccess {
        private final LazyStringArrayList list;

        ByteArrayListView(LazyStringArrayList lazyStringArrayList) {
            this.list = lazyStringArrayList;
        }

        @Override
        public byte[] get(int n) {
            return this.list.getByteArray(n);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public byte[] set(int n, byte[] byArray) {
            Object object = this.list.setAndReturn(n, byArray);
            ++this.modCount;
            return LazyStringArrayList.asByteArray(object);
        }

        @Override
        public void add(int n, byte[] byArray) {
            this.list.add(n, byArray);
            ++this.modCount;
        }

        @Override
        public byte[] remove(int n) {
            String string = this.list.remove(n);
            ++this.modCount;
            return LazyStringArrayList.asByteArray(string);
        }
    }
}

