/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.ListenerConfig;
import com.hazelcast.spi.annotation.Beta;
import com.hazelcast.topic.TopicOverloadPolicy;
import com.hazelcast.util.Preconditions;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;

@Beta
public class ReliableTopicConfig {
    public static final int DEFAULT_READ_BATCH_SIZE = 10;
    public static final TopicOverloadPolicy DEFAULT_TOPIC_OVERLOAD_POLICY = TopicOverloadPolicy.BLOCK;
    public static final boolean DEFAULT_STATISTICS_ENABLED = true;
    private Executor executor;
    private int readBatchSize = 10;
    private String name;
    private boolean statisticsEnabled = true;
    private List<ListenerConfig> listenerConfigs = new LinkedList<ListenerConfig>();
    private TopicOverloadPolicy topicOverloadPolicy = DEFAULT_TOPIC_OVERLOAD_POLICY;

    public ReliableTopicConfig(String name) {
        this.name = Preconditions.checkNotNull(name, "name");
    }

    ReliableTopicConfig(ReliableTopicConfig config) {
        this.name = config.name;
        this.statisticsEnabled = config.statisticsEnabled;
        this.readBatchSize = config.readBatchSize;
        this.executor = config.executor;
        this.topicOverloadPolicy = config.topicOverloadPolicy;
        this.listenerConfigs = config.listenerConfigs;
    }

    ReliableTopicConfig(ReliableTopicConfig config, String name) {
        this(config);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public TopicOverloadPolicy getTopicOverloadPolicy() {
        return this.topicOverloadPolicy;
    }

    public ReliableTopicConfig setTopicOverloadPolicy(TopicOverloadPolicy topicOverloadPolicy) {
        this.topicOverloadPolicy = Preconditions.checkNotNull(topicOverloadPolicy, "topicOverloadPolicy can't be null");
        return this;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public ReliableTopicConfig setExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public int getReadBatchSize() {
        return this.readBatchSize;
    }

    public ReliableTopicConfig setReadBatchSize(int readBatchSize) {
        this.readBatchSize = Preconditions.checkPositive(readBatchSize, "readBatchSize should be positive");
        return this;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public ReliableTopicConfig setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
        return this;
    }

    public List<ListenerConfig> getMessageListenerConfigs() {
        return this.listenerConfigs;
    }

    public ReliableTopicConfig addMessageListenerConfig(ListenerConfig listenerConfig) {
        Preconditions.checkNotNull(listenerConfig, "listenerConfig can't be null");
        this.listenerConfigs.add(listenerConfig);
        return this;
    }

    public ReliableTopicConfig getAsReadOnly() {
        return new ReliableTopicConfigReadOnly(this);
    }

    public String toString() {
        return "ReliableTopicConfig{name='" + this.name + '\'' + ", topicOverloadPolicy=" + (Object)((Object)this.topicOverloadPolicy) + ", executor=" + this.executor + ", readBatchSize=" + this.readBatchSize + ", statisticsEnabled=" + this.statisticsEnabled + ", listenerConfigs=" + this.listenerConfigs + '}';
    }

    static class ReliableTopicConfigReadOnly
    extends ReliableTopicConfig {
        public ReliableTopicConfigReadOnly(ReliableTopicConfig config) {
            super(config);
        }

        @Override
        public ReliableTopicConfig setExecutor(Executor executor) {
            throw new UnsupportedOperationException("This config is read-only");
        }

        @Override
        public ReliableTopicConfig setReadBatchSize(int readBatchSize) {
            throw new UnsupportedOperationException("This config is read-only");
        }

        @Override
        public ReliableTopicConfig setStatisticsEnabled(boolean statisticsEnabled) {
            throw new UnsupportedOperationException("This config is read-only");
        }

        @Override
        public ReliableTopicConfig addMessageListenerConfig(ListenerConfig listenerConfig) {
            throw new UnsupportedOperationException("This config is read-only");
        }

        @Override
        public ReliableTopicConfig setTopicOverloadPolicy(TopicOverloadPolicy topicOverloadPolicy) {
            throw new UnsupportedOperationException("This config is read-only");
        }
    }
}

