/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.truth.AbstractDelegatedVerb;
import com.google.common.truth.DelegatedVerbFactory;
import com.google.common.truth.FailureContext;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.StringUtil;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectFactory;
import javax.annotation.Nullable;

public abstract class AbstractVerb<T extends AbstractVerb<T>>
extends FailureContext {
    private final FailureStrategy failureStrategy;

    public AbstractVerb(FailureStrategy failureStrategy) {
        this(failureStrategy, null, new Object[0]);
    }

    public AbstractVerb(FailureStrategy failureStrategy, @Nullable String format, Object ... args) {
        super(format, args);
        this.failureStrategy = (FailureStrategy)Preconditions.checkNotNull((Object)failureStrategy);
    }

    protected FailureStrategy getFailureStrategy() {
        return this.hasFailureMessage() ? new MessagePrependingFailureStrategy(this.failureStrategy, this) : this.failureStrategy;
    }

    public void fail() {
        this.getFailureStrategy().fail("");
    }

    public void fail(@Nullable String format, Object ... args) {
        this.getFailureStrategy().fail(StringUtil.format(format, args));
    }

    public abstract T withFailureMessage(@Nullable String var1);

    public abstract T withFailureMessage(@Nullable String var1, Object ... var2);

    public <S extends Subject<S, T>, T, SF extends SubjectFactory<S, T>> DelegatedVerb<S, T> about(SF factory) {
        return new DelegatedVerb(this.getFailureStrategy(), factory);
    }

    public <V extends AbstractDelegatedVerb<V>> V about(DelegatedVerbFactory<V> factory) {
        return factory.createVerb(this.getFailureStrategy());
    }

    protected static class MessagePrependingFailureStrategy
    extends FailureStrategy {
        private final FailureStrategy delegate;
        private final FailureContext messageHolder;

        public MessagePrependingFailureStrategy(FailureStrategy delegate, FailureContext messageHolder) {
            this.delegate = (FailureStrategy)Preconditions.checkNotNull((Object)delegate);
            this.messageHolder = (FailureContext)Preconditions.checkNotNull((Object)messageHolder);
        }

        @Override
        public void fail(String message) {
            this.delegate.fail(this.prependFailureMessageIfAny(message));
        }

        @Override
        public void fail(String message, Throwable cause) {
            this.delegate.fail(this.prependFailureMessageIfAny(message), cause);
        }

        @Override
        public void failComparing(String message, CharSequence expected, CharSequence actual) {
            this.delegate.failComparing(this.prependFailureMessageIfAny(message), expected, actual);
        }

        private String prependFailureMessageIfAny(String message) {
            return this.messageHolder.getFailureMessage() == null ? message : this.messageHolder.getFailureMessage() + ": " + message;
        }
    }

    public static final class DelegatedVerb<S extends Subject<S, T>, T>
    extends AbstractDelegatedVerb<DelegatedVerb<S, T>> {
        private final SubjectFactory<S, T> subjectFactory;

        public DelegatedVerb(FailureStrategy failureStrategy, SubjectFactory<S, T> subjectFactory) {
            super(failureStrategy, new Factory(subjectFactory));
            this.subjectFactory = (SubjectFactory)Preconditions.checkNotNull(subjectFactory);
        }

        public S that(@Nullable T target) {
            return this.subjectFactory.getSubject(this.failureStrategy, target);
        }

        private static class Factory<S extends Subject<S, T>, T>
        implements DelegatedVerbFactory<DelegatedVerb<S, T>> {
            private final SubjectFactory<S, T> subjectFactory;

            private Factory(SubjectFactory<S, T> subjectFactory) {
                this.subjectFactory = subjectFactory;
            }

            @Override
            public DelegatedVerb<S, T> createVerb(FailureStrategy failureStrategy) {
                return new DelegatedVerb<S, T>(failureStrategy, this.subjectFactory);
            }
        }
    }
}

