/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.util.Context;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class FSInfo {
    public static FSInfo instance(Context context) {
        FSInfo fSInfo = context.get(FSInfo.class);
        if (fSInfo == null) {
            fSInfo = new FSInfo();
        }
        return fSInfo;
    }

    protected FSInfo() {
    }

    protected FSInfo(Context context) {
        context.put(FSInfo.class, this);
    }

    public File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file.getAbsoluteFile();
        }
    }

    public boolean exists(File file) {
        return file.exists();
    }

    public boolean isDirectory(File file) {
        return file.isDirectory();
    }

    public boolean isFile(File file) {
        return file.isFile();
    }

    public List<File> getJarClassPath(File file) throws IOException {
        String string = file.getParent();
        try (JarFile jarFile = new JarFile(file);){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                List<File> list = Collections.emptyList();
                return list;
            }
            Attributes attributes = manifest.getMainAttributes();
            if (attributes == null) {
                List<File> list = Collections.emptyList();
                return list;
            }
            String string2 = attributes.getValue(Attributes.Name.CLASS_PATH);
            if (string2 == null) {
                List<File> list = Collections.emptyList();
                return list;
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            Object object = new StringTokenizer(string2);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string3 = ((StringTokenizer)object).nextToken();
                File file2 = new File(string3);
                if (!file2.isAbsolute() && string != null) {
                    file2 = new File(string, string3).getAbsoluteFile();
                }
                arrayList.add(file2);
            }
            object = arrayList;
            return object;
        }
    }
}

