/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;

@BugPattern(name="ElementsCountedInLoop", summary="This code, which counts elements using a loop, can be replaced by a simpler library method", explanation="This code counts elements using a loop.  You can use various library methods (Guava's Iterables.size(), Collection.size(), array.length) to achieve the same thing in a cleaner way.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING)
public class ElementsCountedInLoop
extends BugChecker
implements BugChecker.EnhancedForLoopTreeMatcher,
BugChecker.WhileLoopTreeMatcher {
    public Description matchWhileLoop(WhileLoopTree tree, VisitorState state) {
        JCTree.JCWhileLoop whileLoop = (JCTree.JCWhileLoop)tree;
        JCTree.JCExpression whileExpression = ((JCTree.JCParens)whileLoop.getCondition()).getExpression();
        if (whileExpression instanceof MethodInvocationTree) {
            IdentifierTree identifier;
            MethodInvocationTree methodInvocation = (MethodInvocationTree)((Object)whileExpression);
            if (MethodMatchers.instanceMethod().onDescendantOf("java.util.Iterator").withSignature("hasNext()").matches((Tree)methodInvocation, state) && (identifier = this.getIncrementedIdentifer(this.extractSingleStatement(whileLoop.body))) != null) {
                return this.describeMatch(tree);
            }
        }
        return Description.NO_MATCH;
    }

    public Description matchEnhancedForLoop(EnhancedForLoopTree tree, VisitorState state) {
        JCTree.JCEnhancedForLoop enhancedForLoop = (JCTree.JCEnhancedForLoop)tree;
        IdentifierTree identifier = this.getIncrementedIdentifer(this.extractSingleStatement(enhancedForLoop.body));
        if (identifier != null) {
            SuggestedFix fix;
            ExpressionTree expression = tree.getExpression();
            if (Matchers.isSubtypeOf((String)"java.util.Collection").matches((Tree)expression, state)) {
                String replacement = identifier + " += " + expression + ".size();";
                fix = SuggestedFix.replace((Tree)tree, (String)replacement);
            } else if (Matchers.isArrayType().matches((Tree)expression, state)) {
                String replacement = identifier + " += " + expression + ".length;";
                fix = SuggestedFix.replace((Tree)tree, (String)replacement);
            } else {
                String replacement = identifier + " += Iterables.size(" + expression + ");";
                fix = SuggestedFix.builder().replace((Tree)tree, replacement).addImport("com.google.common.collect.Iterables").build();
            }
            return this.describeMatch(tree, (Fix)fix);
        }
        return Description.NO_MATCH;
    }

    private JCTree.JCStatement extractSingleStatement(JCTree.JCStatement body) {
        if (body.getKind() != Tree.Kind.BLOCK) {
            return body;
        }
        JCTree.JCBlock block = (JCTree.JCBlock)body;
        if (((List)block.getStatements()).size() == 1) {
            return (JCTree.JCStatement)((List)block.getStatements()).get(0);
        }
        return null;
    }

    private IdentifierTree getIncrementedIdentifer(JCTree.JCStatement statement) {
        if (statement == null) {
            return null;
        }
        if (statement.getKind() == Tree.Kind.EXPRESSION_STATEMENT) {
            Tree.Kind kind = ((JCTree.JCExpressionStatement)statement).getExpression().getKind();
            if (kind == Tree.Kind.PREFIX_INCREMENT || kind == Tree.Kind.POSTFIX_INCREMENT) {
                JCTree.JCUnary unary = (JCTree.JCUnary)((JCTree.JCExpressionStatement)statement).getExpression();
                if (unary.arg.getKind() == Tree.Kind.IDENTIFIER) {
                    return (IdentifierTree)((Object)unary.arg);
                }
                return null;
            }
            if (kind == Tree.Kind.PLUS_ASSIGNMENT) {
                JCTree.JCAssignOp assignOp = (JCTree.JCAssignOp)((JCTree.JCExpressionStatement)statement).getExpression();
                if (assignOp.lhs.getKind() == Tree.Kind.IDENTIFIER && this.isConstantOne(assignOp.rhs)) {
                    return (IdentifierTree)((Object)assignOp.lhs);
                }
            } else if (kind == Tree.Kind.ASSIGNMENT) {
                JCTree.JCAssign assign = (JCTree.JCAssign)((JCTree.JCExpressionStatement)statement).getExpression();
                if (assign.lhs.getKind() == Tree.Kind.IDENTIFIER && assign.rhs.getKind() == Tree.Kind.PLUS) {
                    JCTree.JCBinary binary = (JCTree.JCBinary)assign.rhs;
                    if (binary.lhs.getKind() == Tree.Kind.IDENTIFIER && ((JCTree.JCIdent)assign.lhs).sym == ((JCTree.JCIdent)binary.lhs).sym && this.isConstantOne(binary.rhs)) {
                        return (IdentifierTree)((Object)binary.lhs);
                    }
                    if (binary.rhs.getKind() == Tree.Kind.IDENTIFIER && ((JCTree.JCIdent)assign.lhs).sym == ((JCTree.JCIdent)binary.rhs).sym && this.isConstantOne(binary.lhs)) {
                        return (IdentifierTree)((Object)binary.rhs);
                    }
                }
            }
        }
        return null;
    }

    private boolean isConstantOne(JCTree.JCExpression exp) {
        int intValue;
        Object literalValue;
        Tree.Kind kind = exp.getKind();
        return (kind == Tree.Kind.INT_LITERAL || kind == Tree.Kind.LONG_LITERAL || kind == Tree.Kind.FLOAT_LITERAL || kind == Tree.Kind.DOUBLE_LITERAL) && exp instanceof LiteralTree && (literalValue = ((LiteralTree)((Object)exp)).getValue()) instanceof Number && (intValue = ((Number)literalValue).intValue()) == 1;
    }
}

