/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.instrumentation.stats.MeasurementMap;
import com.google.instrumentation.stats.RpcConstants;
import com.google.instrumentation.stats.StatsContext;
import com.google.instrumentation.stats.StatsContextFactory;
import com.google.instrumentation.stats.TagValue;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientStreamTracer;
import io.grpc.Context;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerStreamTracer;
import io.grpc.Status;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

final class CensusStreamTracerModule {
    private static final double NANOS_PER_MILLI = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ClientTracer BLANK_CLIENT_TRACER = new ClientTracer();
    @VisibleForTesting
    static final Context.Key<StatsContext> STATS_CONTEXT_KEY = Context.key((String)"io.grpc.internal.StatsContext");
    private final StatsContextFactory statsCtxFactory;
    private final Supplier<Stopwatch> stopwatchSupplier;
    private final Metadata.Key<StatsContext> statsHeader;
    private final CensusClientInterceptor clientInterceptor = new CensusClientInterceptor();
    private final ServerTracerFactory serverTracerFactory = new ServerTracerFactory();

    CensusStreamTracerModule(final StatsContextFactory statsCtxFactory, Supplier<Stopwatch> stopwatchSupplier) {
        this.statsCtxFactory = (StatsContextFactory)Preconditions.checkNotNull((Object)statsCtxFactory, (Object)"statsCtxFactory");
        this.stopwatchSupplier = (Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatchSupplier");
        this.statsHeader = Metadata.Key.of("grpc-census-bin", new Metadata.BinaryMarshaller<StatsContext>(){

            @Override
            public byte[] toBytes(StatsContext context) {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                try {
                    context.serialize((OutputStream)buffer);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return buffer.toByteArray();
            }

            @Override
            public StatsContext parseBytes(byte[] serialized) {
                try {
                    return statsCtxFactory.deserialize((InputStream)new ByteArrayInputStream(serialized));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @VisibleForTesting
    ClientCallTracer newClientCallTracer(StatsContext parentCtx, String fullMethodName) {
        return new ClientCallTracer(parentCtx, fullMethodName);
    }

    ServerStreamTracer.Factory getServerTracerFactory() {
        return this.serverTracerFactory;
    }

    ClientInterceptor getClientInterceptor() {
        return this.clientInterceptor;
    }

    private class CensusClientInterceptor
    implements ClientInterceptor {
        private CensusClientInterceptor() {
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            StatsContext parentCtx = (StatsContext)STATS_CONTEXT_KEY.get();
            if (parentCtx == null) {
                parentCtx = CensusStreamTracerModule.this.statsCtxFactory.getDefault();
            }
            final ClientCallTracer tracerFactory = CensusStreamTracerModule.this.newClientCallTracer(parentCtx, method.getFullMethodName());
            ClientCall<ReqT, RespT> call = next.newCall(method, callOptions.withStreamTracerFactory(tracerFactory));
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

                @Override
                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    this.delegate().start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        @Override
                        public void onClose(Status status, Metadata trailers) {
                            tracerFactory.callEnded(status);
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }

    private final class ServerTracerFactory
    extends ServerStreamTracer.Factory {
        private ServerTracerFactory() {
        }

        @Override
        public ServerStreamTracer newServerStreamTracer(String fullMethodName, Metadata headers) {
            StatsContext parentCtx = (StatsContext)headers.get(CensusStreamTracerModule.this.statsHeader);
            return new ServerTracer(fullMethodName, parentCtx);
        }
    }

    private final class ServerTracer
    extends ServerStreamTracer {
        private final String fullMethodName;
        @Nullable
        private final StatsContext parentCtx;
        private final AtomicBoolean streamClosed = new AtomicBoolean(false);
        private final Stopwatch stopwatch;
        private final AtomicLong outboundWireSize = new AtomicLong();
        private final AtomicLong inboundWireSize = new AtomicLong();
        private final AtomicLong outboundUncompressedSize = new AtomicLong();
        private final AtomicLong inboundUncompressedSize = new AtomicLong();

        ServerTracer(@Nullable String fullMethodName, StatsContext parentCtx) {
            this.fullMethodName = (String)Preconditions.checkNotNull((Object)fullMethodName, (Object)"fullMethodName");
            this.stopwatch = ((Stopwatch)CensusStreamTracerModule.this.stopwatchSupplier.get()).start();
            this.parentCtx = parentCtx;
        }

        @Override
        public void outboundWireSize(long bytes) {
            this.outboundWireSize.addAndGet(bytes);
        }

        @Override
        public void inboundWireSize(long bytes) {
            this.inboundWireSize.addAndGet(bytes);
        }

        @Override
        public void outboundUncompressedSize(long bytes) {
            this.outboundUncompressedSize.addAndGet(bytes);
        }

        @Override
        public void inboundUncompressedSize(long bytes) {
            this.inboundUncompressedSize.addAndGet(bytes);
        }

        @Override
        public void streamClosed(Status status) {
            if (!this.streamClosed.compareAndSet(false, true)) {
                return;
            }
            this.stopwatch.stop();
            long elapsedTimeNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            MeasurementMap.Builder builder = MeasurementMap.builder().put(RpcConstants.RPC_SERVER_SERVER_LATENCY, (double)elapsedTimeNanos / NANOS_PER_MILLI).put(RpcConstants.RPC_SERVER_RESPONSE_BYTES, (double)this.outboundWireSize.get()).put(RpcConstants.RPC_SERVER_REQUEST_BYTES, (double)this.inboundWireSize.get()).put(RpcConstants.RPC_SERVER_UNCOMPRESSED_RESPONSE_BYTES, (double)this.outboundUncompressedSize.get()).put(RpcConstants.RPC_SERVER_UNCOMPRESSED_REQUEST_BYTES, (double)this.inboundUncompressedSize.get());
            if (!status.isOk()) {
                builder.put(RpcConstants.RPC_SERVER_ERROR_COUNT, 1.0);
            }
            StatsContext ctx = (StatsContext)MoreObjects.firstNonNull((Object)this.parentCtx, (Object)CensusStreamTracerModule.this.statsCtxFactory.getDefault());
            ctx.with(RpcConstants.RPC_SERVER_METHOD, TagValue.create((String)this.fullMethodName), RpcConstants.RPC_STATUS, TagValue.create((String)status.getCode().toString())).record(builder.build());
        }

        @Override
        public <ReqT, RespT> Context filterContext(Context context) {
            if (this.parentCtx != null) {
                return context.withValue(STATS_CONTEXT_KEY, (Object)this.parentCtx);
            }
            return context;
        }
    }

    @VisibleForTesting
    final class ClientCallTracer
    extends ClientStreamTracer.Factory {
        private final String fullMethodName;
        private final Stopwatch stopwatch;
        private final AtomicReference<ClientTracer> streamTracer = new AtomicReference();
        private final AtomicBoolean callEnded = new AtomicBoolean(false);
        private final StatsContext parentCtx;

        ClientCallTracer(StatsContext parentCtx, String fullMethodName) {
            this.parentCtx = (StatsContext)Preconditions.checkNotNull((Object)parentCtx, (Object)"parentCtx");
            this.fullMethodName = (String)Preconditions.checkNotNull((Object)fullMethodName, (Object)"fullMethodName");
            this.stopwatch = ((Stopwatch)CensusStreamTracerModule.this.stopwatchSupplier.get()).start();
        }

        @Override
        public ClientStreamTracer newClientStreamTracer(Metadata headers) {
            ClientTracer tracer = new ClientTracer();
            Preconditions.checkState((boolean)this.streamTracer.compareAndSet(null, tracer), (Object)"Are you creating multiple streams per call? This class doesn't yet support this case.");
            headers.discardAll(CensusStreamTracerModule.this.statsHeader);
            headers.put(CensusStreamTracerModule.this.statsHeader, this.parentCtx);
            return tracer;
        }

        void callEnded(Status status) {
            if (!this.callEnded.compareAndSet(false, true)) {
                return;
            }
            this.stopwatch.stop();
            long roundtripNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            ClientTracer tracer = this.streamTracer.get();
            if (tracer == null) {
                tracer = BLANK_CLIENT_TRACER;
            }
            MeasurementMap.Builder builder = MeasurementMap.builder().put(RpcConstants.RPC_CLIENT_ROUNDTRIP_LATENCY, (double)roundtripNanos / NANOS_PER_MILLI).put(RpcConstants.RPC_CLIENT_REQUEST_BYTES, (double)tracer.outboundWireSize.get()).put(RpcConstants.RPC_CLIENT_RESPONSE_BYTES, (double)tracer.inboundWireSize.get()).put(RpcConstants.RPC_CLIENT_UNCOMPRESSED_REQUEST_BYTES, (double)tracer.outboundUncompressedSize.get()).put(RpcConstants.RPC_CLIENT_UNCOMPRESSED_RESPONSE_BYTES, (double)tracer.inboundUncompressedSize.get());
            if (!status.isOk()) {
                builder.put(RpcConstants.RPC_CLIENT_ERROR_COUNT, 1.0);
            }
            this.parentCtx.with(RpcConstants.RPC_CLIENT_METHOD, TagValue.create((String)this.fullMethodName), RpcConstants.RPC_STATUS, TagValue.create((String)status.getCode().toString())).record(builder.build());
        }
    }

    private static final class ClientTracer
    extends ClientStreamTracer {
        final AtomicLong outboundWireSize = new AtomicLong();
        final AtomicLong inboundWireSize = new AtomicLong();
        final AtomicLong outboundUncompressedSize = new AtomicLong();
        final AtomicLong inboundUncompressedSize = new AtomicLong();

        private ClientTracer() {
        }

        @Override
        public void outboundWireSize(long bytes) {
            this.outboundWireSize.addAndGet(bytes);
        }

        @Override
        public void inboundWireSize(long bytes) {
            this.inboundWireSize.addAndGet(bytes);
        }

        @Override
        public void outboundUncompressedSize(long bytes) {
            this.outboundUncompressedSize.addAndGet(bytes);
        }

        @Override
        public void inboundUncompressedSize(long bytes) {
            this.inboundUncompressedSize.addAndGet(bytes);
        }
    }
}

