/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;

@BugPattern(name="ComparableType", summary=" Implementing 'Comparable<T>' where T is not compatible with the implementing class.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR)
public class ComparableType
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<Tree> COMPARABLE_MATCHER = Matchers.isSubtypeOf((String)Comparable.class.getCanonicalName());

    public Description matchClass(ClassTree tree, VisitorState state) {
        Type.ClassType classType;
        Type comparableTypeArgument;
        if (COMPARABLE_MATCHER.matches((Tree)tree, state) && (comparableTypeArgument = ComparableType.getComparableTypeArgument(tree, state)) != null && !ASTHelpers.isCastable((Type)(classType = ASTHelpers.getType((ClassTree)tree)), (Type)comparableTypeArgument, (VisitorState)state)) {
            return this.buildDescription(tree).setMessage(String.format("Type of Comparable (%s) is not compatible with the implementing class (%s).", Signatures.prettyType((Type)comparableTypeArgument), Signatures.prettyType((Type)classType))).build();
        }
        return Description.NO_MATCH;
    }

    private static Type getComparableTypeArgument(ClassTree tree, VisitorState state) {
        Type comparable = state.getTypes().asSuper(ASTHelpers.getType((ClassTree)tree), state.getSymtab().comparableType.asElement());
        if (comparable != null && !comparable.getTypeArguments().isEmpty()) {
            return (Type)Iterables.getOnlyElement(comparable.getTypeArguments());
        }
        return null;
    }
}

