/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.api;

import com.google.common.base.Charsets;
import com.google.common.base.Objects;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public abstract class License {
    private static final String LICENSE_DIR = "licenses";

    public abstract String getId();

    public abstract void setId(String var1);

    public abstract String getValue();

    public abstract void setValue(String var1);

    public String getType() {
        return null;
    }

    public void setType(String type) {
    }

    public String getLicenseHash() {
        return Hashing.sha1().hashBytes(this.getValue().getBytes()).toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<License ref:").append(this.getId()).append(", text:").append(this.getValue()).append(">");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getValue() == null ? 0 : this.getValue().hashCode());
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof License)) {
            return false;
        }
        License other = (License)obj;
        return Objects.equal((Object)this.getValue(), (Object)other.getValue()) && Objects.equal((Object)this.getId(), (Object)other.getId());
    }

    public boolean checkAccepted(File repositoryRoot) {
        if (repositoryRoot == null) {
            return false;
        }
        File licenseDir = new File(repositoryRoot, LICENSE_DIR);
        File licenseFile = new File(licenseDir, this.getId() == null ? this.getLicenseHash() : this.getId());
        if (!licenseFile.exists()) {
            return false;
        }
        try {
            String hash = Files.readFirstLine((File)licenseFile, (Charset)Charsets.UTF_8);
            return hash.equals(this.getLicenseHash());
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean setAccepted(File repositoryRoot) {
        if (repositoryRoot == null) {
            return false;
        }
        if (this.checkAccepted(repositoryRoot)) {
            return true;
        }
        File licenseDir = new File(repositoryRoot, LICENSE_DIR);
        if (licenseDir.exists() && !licenseDir.isDirectory()) {
            return false;
        }
        if (!licenseDir.exists()) {
            licenseDir.mkdir();
        }
        File licenseFile = new File(licenseDir, this.getId() == null ? this.getLicenseHash() : this.getId());
        try {
            Files.write((CharSequence)this.getLicenseHash(), (File)licenseFile, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

