/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;

public class Iterators {
    private static final Iterator EMPTY = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }
    };

    public static <I, O> Iterator<O> createCompoundIterator(Iterable<I> inputs, Function<I, Iterator<O>> convertor) {
        return new CompoundIterator<I, O>(inputs, convertor);
    }

    public static <E> Iterator<E> createFilterIterator(final Iterator<E> input, final Predicate<E> test) {
        return new Iterator<E>(){
            private E current = this.update();

            private E update() {
                while (input.hasNext()) {
                    Object sym = input.next();
                    if (!test.test(sym)) continue;
                    return sym;
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public E next() {
                Object res = this.current;
                this.current = this.update();
                return res;
            }
        };
    }

    private static class CompoundIterator<I, O>
    implements Iterator<O> {
        private final Iterator<I> inputs;
        private final Function<I, Iterator<O>> convertor;
        private Iterator<O> currentIterator = EMPTY;

        public CompoundIterator(Iterable<I> inputs, Function<I, Iterator<O>> convertor) {
            this.inputs = inputs.iterator();
            this.convertor = convertor;
        }

        @Override
        public boolean hasNext() {
            if (this.currentIterator != null && !this.currentIterator.hasNext()) {
                this.update();
            }
            return this.currentIterator != null;
        }

        @Override
        public O next() {
            if (this.currentIterator == EMPTY && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.currentIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void update() {
            while (this.inputs.hasNext()) {
                this.currentIterator = this.convertor.apply(this.inputs.next());
                if (!this.currentIterator.hasNext()) continue;
                return;
            }
            this.currentIterator = null;
        }
    }
}

