/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.StaticImports;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Name;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

@BugPattern(name="BadImport", altNames={"BadNestedImport"}, summary="Importing nested classes/static methods/static fields with commonly-used names can make code harder to read, because it may not be clear from the context exactly which type is being referred to. Qualifying the name with that of the containing class can make the code clearer.", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class BadImport
extends BugChecker
implements BugChecker.ImportTreeMatcher {
    private static final ImmutableSet<String> BAD_NESTED_CLASSES = ImmutableSet.of((Object)"Builder");
    private static final ImmutableSet<String> BAD_STATIC_IDENTIFIERS = ImmutableSet.of((Object)"copyOf", (Object)"of", (Object)"from", (Object)"INSTANCE", (Object)"builder", (Object)"newBuilder", (Object[])new String[0]);
    private static final MultiMatcher<Tree, AnnotationTree> HAS_TYPE_USE_ANNOTATION = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher & Serializable)(t, state) -> BadImport.isTypeAnnotation(t));

    public Description matchImport(ImportTree tree, VisitorState state) {
        ImmutableSet<Symbol> symbols;
        Symbol symbol;
        if (!tree.isStatic()) {
            symbol = ASTHelpers.getSymbol((Tree)tree.getQualifiedIdentifier());
            if (symbol == null || BadImport.isAcceptableImport(symbol, BAD_NESTED_CLASSES)) {
                return Description.NO_MATCH;
            }
            symbols = ImmutableSet.of((Object)symbol);
        } else {
            StaticImports.StaticImportInfo staticImportInfo = StaticImports.tryCreate(tree, state);
            if (staticImportInfo == null || staticImportInfo.members().isEmpty()) {
                return Description.NO_MATCH;
            }
            symbols = staticImportInfo.members();
            symbol = (Symbol)symbols.iterator().next();
            if (BadImport.isAcceptableImport(symbol, BAD_STATIC_IDENTIFIERS)) {
                return Description.NO_MATCH;
            }
        }
        if (symbol.getEnclosingElement() instanceof Symbol.PackageSymbol) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder builder = SuggestedFix.builder().removeImport(symbol.getQualifiedName().toString());
        String replacement = SuggestedFixes.qualifyType((VisitorState)BadImport.getCheckState(state), (SuggestedFix.Builder)builder, (Symbol)symbol.getEnclosingElement()) + ".";
        return this.buildDescription(builder, (Set<Symbol>)symbols, replacement, state);
    }

    private static VisitorState getCheckState(VisitorState state) {
        CompilationUnitTree compilationUnit = state.getPath().getCompilationUnit();
        if (compilationUnit.getTypeDecls().isEmpty()) {
            return state;
        }
        return state.withPath(TreePath.getPath(compilationUnit, compilationUnit.getTypeDecls().get(0)));
    }

    private static boolean isAcceptableImport(Symbol symbol, Set<String> badNames) {
        Name simpleName = symbol.getSimpleName();
        return badNames.stream().noneMatch(simpleName::contentEquals);
    }

    private Description buildDescription(final SuggestedFix.Builder builder, final Set<Symbol> symbols, final String enclosingReplacement, final VisitorState state) {
        CompilationUnitTree compilationUnit = state.getPath().getCompilationUnit();
        TreePath path = TreePath.getPath(compilationUnit, (Tree)compilationUnit);
        IdentifierTree firstFound = (IdentifierTree)new TreePathScanner<IdentifierTree, Void>(){

            @Override
            public IdentifierTree reduce(IdentifierTree r1, IdentifierTree r2) {
                return r2 != null ? r2 : r1;
            }

            @Override
            public IdentifierTree visitClass(ClassTree classTree, Void aVoid) {
                if (BadImport.this.isSuppressed(classTree)) {
                    return null;
                }
                return (IdentifierTree)super.visitClass(classTree, aVoid);
            }

            @Override
            public IdentifierTree visitMethod(MethodTree methodTree, Void aVoid) {
                if (BadImport.this.isSuppressed(methodTree)) {
                    return null;
                }
                return (IdentifierTree)super.visitMethod(methodTree, aVoid);
            }

            @Override
            public IdentifierTree visitVariable(VariableTree variableTree, Void aVoid) {
                if (BadImport.this.isSuppressed(variableTree)) {
                    return null;
                }
                return (IdentifierTree)super.visitVariable(variableTree, aVoid);
            }

            @Override
            public IdentifierTree visitIdentifier(IdentifierTree node, Void aVoid) {
                Symbol nodeSymbol = ASTHelpers.getSymbol((Tree)node);
                if (symbols.contains(nodeSymbol) && !BadImport.this.isSuppressed(node) && this.getCurrentPath().getParentPath().getLeaf().getKind() != Tree.Kind.CASE) {
                    builder.prefixWith((Tree)node, enclosingReplacement);
                    this.moveTypeAnnotations(node);
                    return node;
                }
                return (IdentifierTree)super.visitIdentifier(node, aVoid);
            }

            private void moveTypeAnnotations(IdentifierTree node) {
                Tree parent = this.getCurrentPath().getParentPath().getLeaf();
                switch (parent.getKind()) {
                    case METHOD: 
                    case VARIABLE: 
                    case ANNOTATED_TYPE: {
                        MultiMatcher.MultiMatchResult matchResult = HAS_TYPE_USE_ANNOTATION.multiMatchResult(parent, state);
                        if (!matchResult.matches()) break;
                        for (AnnotationTree annotation : matchResult.matchingNodes()) {
                            builder.delete((Tree)annotation);
                            builder.prefixWith((Tree)node, state.getSourceForNode((Tree)annotation) + " ");
                        }
                        break;
                    }
                }
            }
        }.scan(path, (Void)null);
        if (firstFound == null) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(firstFound, (Fix)builder.build());
    }

    private static boolean isTypeAnnotation(AnnotationTree t) {
        Symbol annotationSymbol = ASTHelpers.getSymbol((Tree)t.getAnnotationType());
        if (annotationSymbol == null) {
            return false;
        }
        Target target = annotationSymbol.getAnnotation(Target.class);
        if (target == null) {
            return false;
        }
        List<ElementType> value = Arrays.asList(target.value());
        return value.contains((Object)ElementType.TYPE_USE) || value.contains((Object)ElementType.TYPE_PARAMETER);
    }
}

