/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.errorprone.SubContext;
import com.google.errorprone.refaster.Bindings;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.URepeated;
import com.google.errorprone.refaster.Unifiable;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public final class Unifier {
    private final Bindings bindings;
    private final Context context;

    public Unifier(Context context) {
        this.bindings = Bindings.create();
        this.context = (Context)Preconditions.checkNotNull((Object)context);
    }

    private Unifier(Context context, Bindings bindings) {
        this.context = new SubContext(context);
        this.bindings = Bindings.create(bindings);
    }

    public Unifier fork() {
        return new Unifier(this.context, this.bindings);
    }

    public Types types() {
        return Types.instance(this.context);
    }

    public JCTree.JCExpression thisExpression(Type type) {
        return TreeMaker.instance(this.context).This(type);
    }

    public Inliner createInliner() {
        return new Inliner(this.context, this.bindings);
    }

    @Nullable
    public <V> V getBinding(Bindings.Key<V> key) {
        return this.bindings.getBinding(key);
    }

    public <V> V putBinding(Bindings.Key<V> key, V value) {
        Preconditions.checkArgument((!this.bindings.containsKey(key) ? 1 : 0) != 0, (String)"Cannot bind %s more than once", key);
        return this.bindings.putBinding(key, value);
    }

    public <V> V replaceBinding(Bindings.Key<V> key, V value) {
        Preconditions.checkArgument((boolean)this.bindings.containsKey(key), (String)"Binding for %s does not exist", key);
        return this.bindings.putBinding(key, value);
    }

    public void clearBinding(Bindings.Key<?> key) {
        this.bindings.remove(key);
    }

    public Bindings getBindings() {
        return this.bindings.unmodifiable();
    }

    public Context getContext() {
        return this.context;
    }

    public String toString() {
        return "Unifier{" + (Object)((Object)this.bindings) + "}";
    }

    public static <T, U extends Unifiable<? super T>> Function<Unifier, Choice<Unifier>> unifications(@Nullable U unifiable, @Nullable T target) {
        return unifier -> Unifier.unifyNullable(unifier, unifiable, target);
    }

    public static <T, U extends Unifiable<? super T>> Choice<Unifier> unifyNullable(Unifier unifier, @Nullable U unifiable, @Nullable T target) {
        if (target == null && unifiable == null) {
            return Choice.of(unifier);
        }
        if (target == null || unifiable == null) {
            return Choice.none();
        }
        return unifiable.unify(target, unifier);
    }

    public static <T, U extends Unifiable<? super T>> Function<Unifier, Choice<Unifier>> unifications(@Nullable List<U> toUnify, @Nullable List<? extends T> targets) {
        return Unifier.unifications(toUnify, targets, false);
    }

    public static <T, U extends Unifiable<? super T>> Function<Unifier, Choice<Unifier>> unifications(@Nullable List<U> toUnify, @Nullable List<? extends T> targets, boolean allowVarargs) {
        return unifier -> Unifier.unifyList(unifier, toUnify, targets, allowVarargs);
    }

    public static <T, U extends Unifiable<? super T>> Choice<Unifier> unifyList(Unifier unifier, @Nullable List<U> toUnify, @Nullable List<? extends T> targets) {
        return Unifier.unifyList(unifier, toUnify, targets, false);
    }

    public static <T, U extends Unifiable<? super T>> Choice<Unifier> unifyList(Unifier unifier, @Nullable List<U> toUnify, final @Nullable List<? extends T> targets, boolean allowVarargs) {
        int index;
        if (toUnify == null && targets == null) {
            return Choice.of(unifier);
        }
        if (toUnify == null || targets == null || (allowVarargs ? toUnify.size() - 1 > targets.size() : toUnify.size() != targets.size())) {
            return Choice.none();
        }
        Choice<Unifier> choice = Choice.of(unifier);
        for (index = 0; index < toUnify.size(); ++index) {
            Unifiable toUnifyNext = (Unifiable)toUnify.get(index);
            if (allowVarargs && toUnifyNext instanceof URepeated) {
                final URepeated repeated = (URepeated)toUnifyNext;
                final int startIndex = index;
                return choice.condition(index + 1 == toUnify.size()).thenOption(new Function<Unifier, Optional<Unifier>>(){

                    public Optional<Unifier> apply(Unifier unifier) {
                        ArrayList<JCTree.JCExpression> expressions = new ArrayList<JCTree.JCExpression>();
                        for (int j = startIndex; j < targets.size(); ++j) {
                            Optional<Unifier> forked = repeated.unify((JCTree)targets.get(j), unifier.fork()).first();
                            if (!forked.isPresent()) {
                                return Optional.absent();
                            }
                            JCTree.JCExpression boundExpr = repeated.getUnderlyingBinding((Unifier)forked.get());
                            if (boundExpr == null) {
                                return Optional.absent();
                            }
                            expressions.add(boundExpr);
                        }
                        unifier.putBinding(repeated.key(), expressions);
                        return Optional.of((Object)unifier);
                    }
                });
            }
            if (index >= targets.size()) {
                return Choice.none();
            }
            choice = choice.thenChoose(Unifier.unifications(toUnifyNext, targets.get(index)));
        }
        if (index < targets.size()) {
            return Choice.none();
        }
        return choice;
    }
}

