/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.android;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.ElementKind;

@BugPattern(name="MislabeledAndroidString", summary="Certain resources in `android.R.string` have names that do not match their content", category=BugPattern.Category.ANDROID, severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class MislabeledAndroidString
extends BugChecker
implements BugChecker.MemberSelectTreeMatcher {
    private static final String R_STRING_CLASSNAME = "android.R.string";
    @VisibleForTesting
    static final ImmutableMap<String, String> MISLEADING = ImmutableMap.of((Object)"yes", (Object)"ok", (Object)"no", (Object)"cancel");
    @VisibleForTesting
    static final ImmutableMap<String, String> ASSUMED_MEANINGS = ImmutableMap.of((Object)"yes", (Object)"Yes", (Object)"no", (Object)"No", (Object)"ok", (Object)"OK", (Object)"cancel", (Object)"Cancel");

    public Description matchMemberSelect(MemberSelectTree tree, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        if (symbol == null || symbol.owner == null || symbol.getKind() != ElementKind.FIELD || !symbol.isStatic() || !R_STRING_CLASSNAME.contentEquals(symbol.owner.getQualifiedName())) {
            return Description.NO_MATCH;
        }
        String misleading = symbol.getSimpleName().toString();
        String preferred = (String)MISLEADING.get((Object)misleading);
        if (preferred == null) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(String.format("%s.%s is not \"%s\" but \"%s\"; prefer %s.%s for clarity", R_STRING_CLASSNAME, misleading, ASSUMED_MEANINGS.get((Object)misleading), ASSUMED_MEANINGS.get((Object)preferred), R_STRING_CLASSNAME, preferred)).addFix((Fix)SuggestedFix.replace((Tree)tree, (String)(tree.getExpression() + "." + preferred))).build();
    }
}

