/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.packaging.zip;

import com.android.builder.internal.packaging.zip.FileUseMapEntry;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

class FileUseMap {
    private long mSize;
    private TreeSet<FileUseMapEntry<?>> mMap;

    FileUseMap(int size) {
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (Object)"size < 0");
        this.mSize = size;
        this.mMap = new TreeSet(FileUseMapEntry.COMPARE_BY_START);
        if (size > 0) {
            this.mMap.add(FileUseMapEntry.makeFree(0L, size));
        }
    }

    private void add(FileUseMapEntry<?> entry) {
        Preconditions.checkArgument((entry.getStart() < this.mSize ? 1 : 0) != 0, (Object)"entry.getStart() >= mSize");
        Preconditions.checkArgument((entry.getEnd() <= this.mSize ? 1 : 0) != 0, (Object)"entry.getEnd() > mSize");
        Preconditions.checkArgument((!entry.isFree() ? 1 : 0) != 0, (Object)"entry.isFree()");
        FileUseMapEntry<?> container = this.findContainer(entry);
        Verify.verify((boolean)container.isFree(), (String)"!container.isFree()", (Object[])new Object[0]);
        Set<FileUseMapEntry<?>> replacements = FileUseMap.split(container, entry);
        this.mMap.remove(container);
        this.mMap.addAll(replacements);
    }

    void remove(FileUseMapEntry<?> entry) {
        Preconditions.checkState((boolean)this.mMap.contains(entry), (Object)"!mMap.contains(entry)");
        this.mMap.remove(entry);
        entry = FileUseMapEntry.makeFree(entry.getStart(), entry.getEnd());
        this.mMap.add(entry);
        this.coalesce(entry);
    }

    <T> FileUseMapEntry<T> add(long start, long end, T store) {
        Preconditions.checkArgument((start >= 0L ? 1 : 0) != 0, (Object)"start < 0");
        Preconditions.checkArgument((end > start ? 1 : 0) != 0, (Object)"end < start");
        Preconditions.checkArgument((store != null ? 1 : 0) != 0, (Object)"store != null");
        FileUseMapEntry<T> entry = FileUseMapEntry.makeUsed(start, end, store);
        this.add(entry);
        return entry;
    }

    private FileUseMapEntry<?> findContainer(FileUseMapEntry<?> entry) {
        FileUseMapEntry<?> container = this.mMap.floor(entry);
        Verify.verifyNotNull(container);
        Verify.verify((container.getStart() <= entry.getStart() ? 1 : 0) != 0);
        Verify.verify((container.getEnd() >= entry.getEnd() ? 1 : 0) != 0);
        return container;
    }

    private static Set<FileUseMapEntry<?>> split(FileUseMapEntry<?> container, FileUseMapEntry<?> entry) {
        Preconditions.checkArgument((boolean)container.isFree(), (Object)"!container.isFree()");
        long farStart = container.getStart();
        long start = entry.getStart();
        long end = entry.getEnd();
        long farEnd = container.getEnd();
        Verify.verify((farStart <= start ? 1 : 0) != 0, (String)"farStart > start", (Object[])new Object[0]);
        Verify.verify((start < end ? 1 : 0) != 0, (String)"start >= end", (Object[])new Object[0]);
        Verify.verify((farEnd >= end ? 1 : 0) != 0, (String)"farEnd < end", (Object[])new Object[0]);
        HashSet result = Sets.newHashSet();
        if (farStart < start) {
            result.add(FileUseMapEntry.makeFree(farStart, start));
        }
        result.add(entry);
        if (end < farEnd) {
            result.add(FileUseMapEntry.makeFree(end, farEnd));
        }
        return result;
    }

    private void coalesce(FileUseMapEntry<?> entry) {
        FileUseMapEntry<Object> prevToMerge = null;
        long start = entry.getStart();
        if (start > 0L) {
            prevToMerge = this.mMap.floor(FileUseMapEntry.makeFree(start - 1L, start));
            Verify.verifyNotNull(prevToMerge);
            if (!prevToMerge.isFree()) {
                prevToMerge = null;
            }
        }
        FileUseMapEntry<Object> nextToMerge = null;
        long end = entry.getEnd();
        if (end < this.mSize) {
            nextToMerge = this.mMap.ceiling(FileUseMapEntry.makeFree(end, end + 1L));
            Verify.verifyNotNull(nextToMerge);
            if (!nextToMerge.isFree()) {
                nextToMerge = null;
            }
        }
        if (prevToMerge == null && nextToMerge == null) {
            return;
        }
        long newStart = start;
        if (prevToMerge != null) {
            newStart = prevToMerge.getStart();
            this.mMap.remove(prevToMerge);
        }
        long newEnd = end;
        if (nextToMerge != null) {
            newEnd = nextToMerge.getEnd();
            this.mMap.remove(nextToMerge);
        }
        this.mMap.remove(entry);
        this.mMap.add(FileUseMapEntry.makeFree(newStart, newEnd));
    }

    void truncate() {
        if (this.mSize == 0L) {
            return;
        }
        FileUseMapEntry<?> last = this.mMap.last();
        Verify.verifyNotNull(last, (String)"last == null", (Object[])new Object[0]);
        if (last.isFree()) {
            this.mMap.remove(last);
            this.mSize = last.getStart();
        }
    }

    long size() {
        return this.mSize;
    }

    long usedSize() {
        if (this.mSize == 0L) {
            return 0L;
        }
        FileUseMapEntry<?> last = this.mMap.last();
        Verify.verifyNotNull(last, (String)"last == null", (Object[])new Object[0]);
        if (last.isFree()) {
            this.mMap.remove(last);
            return last.getStart();
        }
        return this.mSize;
    }

    void extend(long size) {
        Preconditions.checkArgument((size >= this.mSize ? 1 : 0) != 0, (Object)"size < mSize");
        if (this.mSize == size) {
            return;
        }
        FileUseMapEntry<Object> newBlock = FileUseMapEntry.makeFree(this.mSize, size);
        this.mMap.add(newBlock);
        this.mSize = size;
        this.coalesce(newBlock);
    }

    long locateFree(long size, long alignOffset, long align) {
        FileUseMapEntry<?> last;
        Preconditions.checkArgument((size > 0L ? 1 : 0) != 0, (Object)"size <= 0");
        FileUseMapEntry<?> best = null;
        long bestExtraSize = 0L;
        for (FileUseMapEntry<?> curr : this.mMap) {
            if (!curr.isFree()) continue;
            long extraSize = (align - (curr.getStart() + alignOffset) % align) % align;
            if (curr.getSize() < size + extraSize || best != null && best.getSize() < curr.getSize()) continue;
            best = curr;
            bestExtraSize = extraSize;
        }
        long firstFree = this.mSize;
        if (best == null && !this.mMap.isEmpty() && (last = this.mMap.last()).isFree()) {
            firstFree = last.getStart();
        }
        if (best == null) {
            long extra = (align - (firstFree + alignOffset) % align) % align;
            return firstFree + extra;
        }
        return best.getStart() + bestExtraSize;
    }
}

