/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javah;

import com.sun.tools.javah.Gen;
import com.sun.tools.javah.TypeSignature;
import com.sun.tools.javah.Util;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public class JNI
extends Gen {
    JNI(Util util) {
        super(util);
    }

    @Override
    public String getIncludes() {
        return "#include <jni.h>";
    }

    @Override
    public void write(OutputStream o, TypeElement clazz) throws Util.Exit {
        try {
            String cname = this.mangler.mangle(clazz.getQualifiedName(), 1);
            PrintWriter pw = this.wrapWriter(o);
            pw.println(this.guardBegin(cname));
            pw.println(this.cppGuardBegin());
            List<VariableElement> classfields = this.getAllFields(clazz);
            for (VariableElement v : classfields) {
                if (!v.getModifiers().contains((Object)Modifier.STATIC)) continue;
                String s = null;
                s = this.defineForStatic(clazz, v);
                if (s == null) continue;
                pw.println(s);
            }
            List<ExecutableElement> classmethods = ElementFilter.methodsIn(clazz.getEnclosedElements());
            for (ExecutableElement md : classmethods) {
                if (!md.getModifiers().contains((Object)Modifier.NATIVE)) continue;
                TypeMirror mtr = this.types.erasure(md.getReturnType());
                String sig = this.signature(md);
                TypeSignature newtypesig = new TypeSignature(this.elems);
                Name methodName = md.getSimpleName();
                boolean longName = false;
                for (ExecutableElement md2 : classmethods) {
                    if (md2 == md || !((Object)methodName).equals(md2.getSimpleName()) || !md2.getModifiers().contains((Object)Modifier.NATIVE)) continue;
                    longName = true;
                }
                pw.println("/*");
                pw.println(" * Class:     " + cname);
                pw.println(" * Method:    " + this.mangler.mangle(methodName, 2));
                pw.println(" * Signature: " + newtypesig.getTypeSignature(sig, mtr));
                pw.println(" */");
                pw.println("JNIEXPORT " + this.jniType(mtr) + " JNICALL " + this.mangler.mangleMethod(md, clazz, longName ? 8 : 7));
                pw.print("  (JNIEnv *, ");
                List<? extends VariableElement> paramargs = md.getParameters();
                ArrayList<TypeMirror> args = new ArrayList<TypeMirror>();
                for (VariableElement variableElement : paramargs) {
                    args.add(this.types.erasure(variableElement.asType()));
                }
                if (md.getModifiers().contains((Object)Modifier.STATIC)) {
                    pw.print("jclass");
                } else {
                    pw.print("jobject");
                }
                for (TypeMirror typeMirror : args) {
                    pw.print(", ");
                    pw.print(this.jniType(typeMirror));
                }
                pw.println(");" + this.lineSep);
            }
            pw.println(this.cppGuardEnd());
            pw.println(this.guardEnd(cname));
        }
        catch (TypeSignature.SignatureException e) {
            this.util.error("jni.sigerror", e.getMessage());
        }
    }

    protected final String jniType(TypeMirror t) throws Util.Exit {
        TypeElement throwable = this.elems.getTypeElement("java.lang.Throwable");
        TypeElement jClass = this.elems.getTypeElement("java.lang.Class");
        TypeElement jString = this.elems.getTypeElement("java.lang.String");
        Element tclassDoc = this.types.asElement(t);
        switch (t.getKind()) {
            case ARRAY: {
                TypeMirror ct2 = ((ArrayType)t).getComponentType();
                switch (ct2.getKind()) {
                    case BOOLEAN: {
                        return "jbooleanArray";
                    }
                    case BYTE: {
                        return "jbyteArray";
                    }
                    case CHAR: {
                        return "jcharArray";
                    }
                    case SHORT: {
                        return "jshortArray";
                    }
                    case INT: {
                        return "jintArray";
                    }
                    case LONG: {
                        return "jlongArray";
                    }
                    case FLOAT: {
                        return "jfloatArray";
                    }
                    case DOUBLE: {
                        return "jdoubleArray";
                    }
                    case ARRAY: 
                    case DECLARED: {
                        return "jobjectArray";
                    }
                }
                throw new Error(ct2.toString());
            }
            case VOID: {
                return "void";
            }
            case BOOLEAN: {
                return "jboolean";
            }
            case BYTE: {
                return "jbyte";
            }
            case CHAR: {
                return "jchar";
            }
            case SHORT: {
                return "jshort";
            }
            case INT: {
                return "jint";
            }
            case LONG: {
                return "jlong";
            }
            case FLOAT: {
                return "jfloat";
            }
            case DOUBLE: {
                return "jdouble";
            }
            case DECLARED: {
                if (tclassDoc.equals(jString)) {
                    return "jstring";
                }
                if (this.types.isAssignable(t, throwable.asType())) {
                    return "jthrowable";
                }
                if (this.types.isAssignable(t, jClass.asType())) {
                    return "jclass";
                }
                return "jobject";
            }
        }
        this.util.bug("jni.unknown.type");
        return null;
    }
}

