---
layout: documentation
title: Getting Started
---

# Getting Started with Bazel

This page lists material that will help you get started with Bazel. If you have
not already done so, first read the [Bazel Overview](bazel-overview.html).

## Installation

To install Bazel, see [Installing Bazel](install.html).


## Tutorials

To get hands-on with Bazel and understand its core concepts, complete a
tutorial:

*   [Tutorial: Build a C++ Project](tutorial/cpp.html)

*   [Tutorial: Build a Java Project](tutorial/java.html)

*   [Tutorial: Build an Android Application](tutorial/android-app.html)

*   [Tutorial: Build an iOS Application](tutorial/ios-app.html)


## Migration

To learn how to migrate your project to Bazel, see the appropriate migration
guide:

*   [Migrating from Maven to Bazel](migrate-maven.html)

*   [Migrating from Xcode to Bazel](migrate-xcode.html)


## Language-specific resources

Once you are familiar with Bazel, take a look at the language-specific
resources, such as functions and build rules:

*   [C++ and Bazel](bazel-and-cpp.html)

*   [Java and Bazel](bazel-and-java.html)

*   [Android and Bazel](bazel-and-android.html)

*   [Apple apps and Bazel](bazel-and-apple.html)


## Reference

To further explore Bazel, refer to the following resources:

*   [Bazel Concepts and Terminology](build-ref.html)

*   [Bazel User Manual](user-manual.html)

*   [Build Encyclopedia](https://docs.bazel.build/versions/master/be/overview.html)
