/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.types;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import com.google.turbine.types.Erasure;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Canonicalize {
    public static Type canonicalize(SourceFile source, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol base, Type type) {
        switch (type.tyKind()) {
            case PRIM_TY: 
            case VOID_TY: 
            case TY_VAR: {
                return type;
            }
            case WILD_TY: {
                return Canonicalize.canonicalizeWildTy(source, env, base, (Type.WildTy)type);
            }
            case ARRAY_TY: {
                Type.ArrayTy arrayTy = (Type.ArrayTy)type;
                return new Type.ArrayTy(Canonicalize.canonicalize(source, env, base, arrayTy.elementType()), arrayTy.annos());
            }
            case CLASS_TY: {
                return Canonicalize.canonicalizeClassTy(source, env, base, (Type.ClassTy)type);
            }
        }
        throw new AssertionError((Object)type.tyKind());
    }

    private static Type.ClassTy canon(SourceFile source, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol base, Type.ClassTy ty) {
        Type.ClassTy canon;
        if (Canonicalize.isRaw(env, ty)) {
            return Erasure.eraseClassTy(ty);
        }
        UnmodifiableIterator it = ty.classes.iterator();
        Collection<Type.ClassTy.SimpleClassTy> lexicalBase = Canonicalize.lexicalBase(source, env, ((Type.ClassTy.SimpleClassTy)ty.classes.get(0)).sym(), base);
        Type.ClassTy classTy = canon = !lexicalBase.isEmpty() ? new Type.ClassTy(lexicalBase) : new Type.ClassTy(Collections.singletonList(it.next()));
        while (it.hasNext()) {
            canon = Canonicalize.canonOne(source, env, canon, (Type.ClassTy.SimpleClassTy)it.next());
        }
        return canon;
    }

    private static boolean isRaw(Env<ClassSymbol, TypeBoundClass> env, Type.ClassTy ty) {
        for (Type.ClassTy.SimpleClassTy s : ty.classes.reverse()) {
            TypeBoundClass info = env.get(s.sym());
            if (s.targs().isEmpty() && !info.typeParameters().isEmpty()) {
                return true;
            }
            if ((info.access() & 8) != 8) continue;
            break;
        }
        return false;
    }

    private static Collection<Type.ClassTy.SimpleClassTy> lexicalBase(SourceFile source, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol first, ClassSymbol owner) {
        if ((env.get(first).access() & 8) == 8) {
            return Collections.emptyList();
        }
        ClassSymbol canonOwner = env.get(first).owner();
        ArrayDeque<Type.ClassTy.SimpleClassTy> result = new ArrayDeque<Type.ClassTy.SimpleClassTy>();
        while (canonOwner != null && owner != null) {
            if (!Canonicalize.isSubclass(env, owner, canonOwner)) {
                owner = env.get(owner).owner();
                continue;
            }
            result.addFirst(Canonicalize.uninstantiated(env, owner));
            if ((env.get(owner).access() & 8) == 8) break;
            TypeBoundClass info = env.get(canonOwner);
            if (info == null) {
                throw TurbineError.format(source, TurbineError.ErrorKind.CLASS_FILE_NOT_FOUND, canonOwner);
            }
            canonOwner = info.owner();
        }
        return result;
    }

    private static Type.ClassTy.SimpleClassTy uninstantiated(Env<ClassSymbol, TypeBoundClass> env, ClassSymbol owner) {
        ImmutableList.Builder targs = ImmutableList.builder();
        for (TyVarSymbol p : env.get(owner).typeParameterTypes().keySet()) {
            targs.add((Object)new Type.TyVar(p, (ImmutableList<AnnoInfo>)ImmutableList.of()));
        }
        return new Type.ClassTy.SimpleClassTy(owner, (ImmutableList<Type>)targs.build(), (ImmutableList<AnnoInfo>)ImmutableList.of());
    }

    static boolean isSubclass(Env<ClassSymbol, TypeBoundClass> env, ClassSymbol s, ClassSymbol t) {
        while (s != null) {
            if (s.equals(t)) {
                return true;
            }
            s = env.get(s).superclass();
        }
        return false;
    }

    private static Type.ClassTy canonOne(SourceFile source, Env<ClassSymbol, TypeBoundClass> env, Type.ClassTy base, Type.ClassTy.SimpleClassTy ty) {
        if ((env.get(ty.sym()).access() & 8) == 8) {
            return new Type.ClassTy(Collections.singletonList(ty));
        }
        ImmutableList.Builder simples = ImmutableList.builder();
        ClassSymbol owner = env.get(ty.sym()).owner();
        if (owner.equals(base.sym())) {
            simples.addAll(base.classes);
            simples.add((Object)ty);
            return new Type.ClassTy((Iterable<Type.ClassTy.SimpleClassTy>)simples.build());
        }
        Type.ClassTy curr = base;
        LinkedHashMap<TyVarSymbol, Type> mapping = new LinkedHashMap<TyVarSymbol, Type>();
        while (curr != null) {
            for (Type.ClassTy.SimpleClassTy s : curr.classes) {
                Canonicalize.addInstantiation(env, mapping, s);
            }
            if (curr.sym().equals(owner)) {
                for (Type.ClassTy.SimpleClassTy s : curr.classes) {
                    simples.add((Object)Canonicalize.instantiate(env, mapping, s.sym()));
                }
                break;
            }
            TypeBoundClass info = env.get(curr.sym());
            curr = Canonicalize.canon(source, env, info.owner(), info.superClassType());
        }
        simples.add((Object)ty);
        return new Type.ClassTy((Iterable<Type.ClassTy.SimpleClassTy>)simples.build());
    }

    static void addInstantiation(Env<ClassSymbol, TypeBoundClass> env, Map<TyVarSymbol, Type> mapping, Type.ClassTy.SimpleClassTy simpleType) {
        ImmutableCollection symbols = env.get(simpleType.sym()).typeParameters().values();
        if (simpleType.targs().isEmpty()) {
            for (TyVarSymbol sym : symbols) {
                mapping.put(sym, null);
            }
            return;
        }
        Verify.verify((symbols.size() == simpleType.targs().size() ? 1 : 0) != 0);
        UnmodifiableIterator typeArguments = simpleType.targs().iterator();
        for (TyVarSymbol sym : symbols) {
            Type argument = (Type)typeArguments.next();
            if (Objects.equals(Canonicalize.tyVarSym(argument), sym)) continue;
            mapping.put(sym, argument);
        }
    }

    static Type.ClassTy.SimpleClassTy instantiate(Env<ClassSymbol, TypeBoundClass> env, Map<TyVarSymbol, Type> mapping, ClassSymbol classSymbol) {
        ArrayList<Type> args = new ArrayList<Type>();
        for (TyVarSymbol sym : env.get(classSymbol).typeParameterTypes().keySet()) {
            if (!mapping.containsKey(sym)) {
                args.add(new Type.TyVar(sym, (ImmutableList<AnnoInfo>)ImmutableList.of()));
                continue;
            }
            Type arg = Canonicalize.instantiate(mapping, mapping.get(sym));
            if (arg == null) {
                args.clear();
                break;
            }
            args.add(arg);
        }
        return new Type.ClassTy.SimpleClassTy(classSymbol, (ImmutableList<Type>)ImmutableList.copyOf(args), (ImmutableList<AnnoInfo>)ImmutableList.of());
    }

    private static Type instantiate(Map<TyVarSymbol, Type> mapping, Type type) {
        if (type == null) {
            return null;
        }
        switch (type.tyKind()) {
            case WILD_TY: {
                return Canonicalize.instantiateWildTy(mapping, (Type.WildTy)type);
            }
            case PRIM_TY: 
            case VOID_TY: {
                return type;
            }
            case CLASS_TY: {
                return Canonicalize.instantiateClassTy(mapping, (Type.ClassTy)type);
            }
            case ARRAY_TY: {
                Type.ArrayTy arrayTy = (Type.ArrayTy)type;
                Type elem = Canonicalize.instantiate(mapping, arrayTy.elementType());
                return new Type.ArrayTy(elem, arrayTy.annos());
            }
            case TY_VAR: {
                Type.TyVar tyVar = (Type.TyVar)type;
                if (mapping.containsKey(tyVar.sym())) {
                    return Canonicalize.instantiate(mapping, mapping.get(tyVar.sym()));
                }
                return type;
            }
        }
        throw new AssertionError((Object)type.tyKind());
    }

    private static Type instantiateWildTy(Map<TyVarSymbol, Type> mapping, Type.WildTy type) {
        switch (type.boundKind()) {
            case NONE: {
                return type;
            }
            case UPPER: {
                return new Type.WildUpperBoundedTy(Canonicalize.instantiate(mapping, type.bound()), type.annotations());
            }
            case LOWER: {
                return new Type.WildLowerBoundedTy(Canonicalize.instantiate(mapping, type.bound()), type.annotations());
            }
        }
        throw new AssertionError((Object)type.boundKind());
    }

    private static Type instantiateClassTy(Map<TyVarSymbol, Type> mapping, Type.ClassTy type) {
        ImmutableList.Builder simples = ImmutableList.builder();
        for (Type.ClassTy.SimpleClassTy simple : type.classes) {
            ImmutableList.Builder args = ImmutableList.builder();
            for (Type arg : simple.targs()) {
                args.add((Object)Canonicalize.instantiate(mapping, arg));
            }
            simples.add((Object)new Type.ClassTy.SimpleClassTy(simple.sym(), (ImmutableList<Type>)args.build(), simple.annos()));
        }
        return new Type.ClassTy((Iterable<Type.ClassTy.SimpleClassTy>)simples.build());
    }

    private static @Nullable TyVarSymbol tyVarSym(Type type) {
        if (type.tyKind() == Type.TyKind.TY_VAR) {
            return ((Type.TyVar)type).sym();
        }
        return null;
    }

    public static Type.ClassTy canonicalizeClassTy(SourceFile source, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol base, Type.ClassTy ty) {
        ImmutableList.Builder args = ImmutableList.builder();
        for (Type.ClassTy.SimpleClassTy s : ty.classes) {
            args.add((Object)new Type.ClassTy.SimpleClassTy(s.sym(), Canonicalize.canonicalize(source, s.targs(), base, env), s.annos()));
        }
        ty = new Type.ClassTy((Iterable<Type.ClassTy.SimpleClassTy>)args.build());
        return Canonicalize.canon(source, env, base, ty);
    }

    private static ImmutableList<Type> canonicalize(SourceFile source, ImmutableList<Type> targs, ClassSymbol base, Env<ClassSymbol, TypeBoundClass> env) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Type a : targs) {
            result.add((Object)Canonicalize.canonicalize(source, env, base, a));
        }
        return result.build();
    }

    private static Type canonicalizeWildTy(SourceFile source, Env<ClassSymbol, TypeBoundClass> env, ClassSymbol base, Type.WildTy type) {
        switch (type.boundKind()) {
            case NONE: {
                return type;
            }
            case LOWER: {
                return new Type.WildLowerBoundedTy(Canonicalize.canonicalize(source, env, base, type.bound()), type.annotations());
            }
            case UPPER: {
                return new Type.WildUpperBoundedTy(Canonicalize.canonicalize(source, env, base, type.bound()), type.annotations());
            }
        }
        throw new AssertionError((Object)type.boundKind());
    }
}

